package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 读建筑消防设施操作信息记录
 * <p>
 * 类型值: 64
 * 方向: 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * -------------------
 * 系统类型(1字节)
 * 系统地址(1字节)
 * 查询操作信息记录数目(1字节)
 * 查询记录的指定起始时间(6字节)
 */

@TypeFlagMappingAnnotation(value = "64", direction = false)
public class ReadBuildingFireOperationRecord extends AbstractTypeFlagConvert {

    /**
     * must be one count
     *
     * @return
     */
    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {

        if (!map.containsKey(TypeFlagKey.OP_INFO_RECORD_COUNT)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.OP_INFO_RECORD_COUNT);
        }
        if (!map.containsKey(ConstantKey.START_DATE_TIME)) {
            throw new MissingTypFlagJsonKeyException(ConstantKey.START_DATE_TIME);
        }

        int opInfoRecordCount = Integer.parseInt(map.get(TypeFlagKey.OP_INFO_RECORD_COUNT).toString());
        String startTime = map.get(ConstantKey.START_DATE_TIME).toString();
        final byte[] startTimeByte = HexUtil.checkByteArrayLen(HexUtil.hexToByteArray(startTime), 6);

        return concatSystem(systemType, systemAddress, HexUtil.intToByteArray(opInfoRecordCount, 1), startTimeByte);
    }
}
