package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 读建筑消防设施软件版本
 * <p>
 * 类型值: 65
 * 方向 : 下行
 * <p>
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ---------------
 * 系统类型(1字节)
 * 系统地址(1字节)
 */

@TypeFlagMappingAnnotation(value = "65", direction = false)
public class ReadBuildingFireSoftwareVersion extends AbstractTypeFlagConvert {
    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return concatSystem(systemType, systemAddress);
    }
}
