package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 读建筑消防设施系统配置情况
 * <p>
 * 类型值: 66
 * 方向 : 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ---------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * ..................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 */

@TypeFlagMappingAnnotation(value = "66", direction = false)
public class ReadBuildingFireSystemConfiguration extends AbstractTypeFlagConvert {
    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return concatSystem(systemType, systemAddress);
    }
}
