package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 读建筑消防设施系统状态
 * <p>
 * 类型值: 61
 * 方向 : 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象教目(1字节)
 * -------------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * ...................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 */

@TypeFlagMappingAnnotation(value = "61", direction = false)
public class ReadBuildingFireSystemStatus extends AbstractTypeFlagConvert {

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) {
        return concatSystem(systemType, systemAddress);
    }
}
