package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 读建筑消防设施系统时间
 * <p>
 * 类型值: 68
 * 方向 : 下行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数日(1字节)   = 1
 * -----------------------
 * 系统类型(1字节)
 * 系统地址(1字节)
 */
@TypeFlagMappingAnnotation(value = "68", direction = false)
public class ReadBuildingFireSystemTime extends AbstractTypeFlagConvert {
    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return concatSystem(systemType, systemAddress);
    }
}
