package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 读用户信息传输装置操作信息记录
 * <p>
 * 类型值: 84
 * 方向 : 下行
 * <p>
 * 类型标志符(1宇节)
 * 信息对象数日(1字节) == 1
 * -------------------------
 * 查询操作信息记录敦目(1字节)
 * 查询记录的指定起始时间(6字节)
 */

@TypeFlagMappingAnnotation(value = "84", direction = false)
public class ReadUserInfoTransportOpetationRecord extends AbstractTypeFlagConvert {

    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {

        if (!map.containsKey(TypeFlagKey.OP_INFO_RECORD_COUNT)) {
            throw new MissingTypFlagJsonKeyException(TypeFlagKey.OP_INFO_RECORD_COUNT);
        }
        if (!map.containsKey(ConstantKey.START_DATE_TIME)) {
            throw new MissingTypFlagJsonKeyException(ConstantKey.START_DATE_TIME);
        }
        String opRecord = map.get(TypeFlagKey.OP_INFO_RECORD_COUNT).toString();
        String startDateTime = map.get(ConstantKey.START_DATE_TIME).toString();

        int opRecordCount = Integer.parseInt(opRecord);

        return concatSystem(systemType, systemAddress, HexUtil.intToByteArray(opRecordCount, 1), HexUtil.hexToByteArray(startDateTime));
    }
}
