package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 用户信息传输装置软件版本
 * <p>
 * 类型值: 85
 * 方向 : 下行
 * <p>
 * 类型标志符(1)
 * 信息对象数目(1)
 * --------------
 * 预留(1) == 0
 */

@TypeFlagMappingAnnotation(value = "85", direction = false)
public class ReadUserInfoTransportSoftwareVersion extends AbstractTypeFlagConvert {

    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    /**
     * override
     *
     * @param typeFlag
     * @param map
     * @return
     * @throws MissingTypFlagJsonKeyException
     */
    @Override
    public byte[] convertInfoObjectItem(int typeFlag, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        Object reservedObject = map.get(TypeFlagKey.RESERVED);
        int reserved;
        if (reservedObject == null) {
            reserved = 0;
        } else {
            reserved = Integer.parseInt(reservedObject.toString());
        }
        return HexUtil.intToByteArray(reserved, 1);
    }

    /**
     * 没用这个方法
     *
     * @param typeFlag
     * @param systemType
     * @param systemAddress
     * @param map
     * @return
     * @throws MissingTypFlagJsonKeyException
     */
    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return new byte[0];
    }
}
