package com.vcarecity.gbtparser.typeflag.convert;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.exception.MissingTypFlagJsonKeyException;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagConvert;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * @author Kerry on 18/08/15
 * <p>
 * 同步用户信息传输装置时间
 * <p>
 * 类型值: 90
 * 方向 : 下行
 * <p>
 * 类型标志符(1)
 * 信息对象数目(1)
 * --------------
 * 中心系统时间(6)
 */

@TypeFlagMappingAnnotation(value = "90", direction = false)
public class SyncUserInfoTransportTime extends AbstractTypeFlagConvert {
    @Override
    public Integer getInfoObjectCount() {
        return 1;
    }

    @Override
    public byte[] convertInfoObjectItem(int typeFlag, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        String dateTime;
        Object dt = map.get(ConstantKey.DATE_TIME);
        if (dt == null) {
            dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern(ConstantKey.GBT_DATE_FORMAT));
        } else {
            dateTime = dt.toString();
        }
        return HexUtil.hexToByteArray(dateTime);
    }

    @Override
    protected byte[] convertInfoObjectItem(int typeFlag, int systemType, int systemAddress, Map<String, Object> map) throws MissingTypFlagJsonKeyException {
        return new byte[0];
    }
}
