package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/13
 * <p>
 * 上传建筑消防设施操作信息
 * <p>
 * 类型值: 4
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ---------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 操作信息1(1字节)
 * 操作员编号1(1字节)
 * 操作1的记录时间(6字节)
 * ..................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 操作信息n(1字节)
 * 操作员编号n(1字节)
 * 操作n的记录时间(6字节)
 */

@TypeFlagMappingAnnotation("4")
public class UpBuildingFireOperationInfo extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 4;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {


        final int operationFlag = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final int operatorNumber = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.OPERATION_FLAG, operationFlag);
        map.put(TypeFlagKey.OPERATOR_NO, operatorNumber);
        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }
}
