package com.vcarecity.gbtparser.typeflag.parser;


import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传建筑消防设施部件配置情况
 * <p>
 * 类型值: 7
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * -------------------
 * 系统共型1(1字节)
 * 系统地址1(1字节)
 * 部件类型l(1字节)
 * 部件地址1(字节)
 * 部件说明1(31字节)
 * ....................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 部件类型n(1字节)
 * 部件地址n(字节)
 * 部件说明n(31字节)
 */

@TypeFlagMappingAnnotation("7")
public class UpBuildingFirePartConfiguration extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 38;
    }

    /**
     * 没有时间
     *
     * @return
     */
    @Override
    public int dateTimeLen() {
        return 0;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        int pos = 0;
        final int systemType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        final int systemAddress = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        final int partType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        final String partAddress = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 4));
        pos += 4;

        final byte[] pd = Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 31);
        final String partDescription = new String(pd, Charset.forName(ConstantKey.GB18030_CHARSET)).trim();

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.PART_TYPE, partType);
        map.put(TypeFlagKey.PART_ADDRESS, partAddress);
        map.put(TypeFlagKey.PART_DESCRIPTION, partDescription);
        return map;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {
        final int partType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        String partAddress = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 4));
        currentPosition += 4;

        byte[] pd = Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 31);
        String partDescription = new String(pd, Charset.forName(ConstantKey.GB18030_CHARSET)).trim();
        currentPosition += pd.length;

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.PART_TYPE, partType);
        map.put(TypeFlagKey.PART_ADDRESS, partAddress);
        map.put(TypeFlagKey.PART_DESCRIPTION, partDescription);

        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }
}
