package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/13
 * <p>
 * 上传建筑消防设施软件版本
 * <p>
 * 类型值: 5
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ----------------
 * 系统类型(1字节)
 * 系统地址(1字节)
 * 软件主版本号(1字节)
 * 软件次版本号(1字节)
 */

@TypeFlagMappingAnnotation("5")
public class UpBuildingFireSoftwareVersion extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 4;
    }

    /**
     * 没有时间,所以override,return 0
     *
     * @return
     */
    @Override
    public int dateTimeLen() {
        return 0;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {

        final int majorVersion = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final int minorVersion = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        Map<String, Object> map = new HashMap<>(8);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.MAJOR_VERSION, majorVersion);
        map.put(TypeFlagKey.MINOR_VERSION, minorVersion);

        return map;
    }
}
