package com.vcarecity.gbtparser.typeflag.parser;


import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.ITypeFlagParser;
import org.jetbrains.annotations.Nullable;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传建筑消防设施系统配置情况
 * <p>
 * 类型值: 6
 * 方向 : 上行
 * <p>
 * 娄型标志符(1字节)
 * 信息对象数目(1宇节)
 * -----------------
 * 系统类型1(1字节)
 * 系统地址l(1字节)
 * 系统说明长度1(1字节)
 * 系统说明I(L1字节)
 * ................< 3
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 系统说明长度n(1字节)
 * 系统说明月(Ln字节)
 */

@TypeFlagMappingAnnotation("6")
public class UpBuildingFireSystemConfiguration implements ITypeFlagParser {
    /**
     * 当前项为不定长数据,这个返回值不生效
     *
     * @return
     */
    @Override
    public int getSingleDataInfoLength() {
        return 0;
    }


    /**
     * 不定长重写截取
     *
     * @param pos
     * @param dataInfoCount
     * @param appData
     * @return
     */
    @Nullable
    @Override
    public byte[][] indefiniteLength(int pos, int dataInfoCount, byte[] appData) {
        byte[][] indefiniteData = new byte[dataInfoCount][];
        int index = 0;
        while (index < dataInfoCount) {
            int len = HexUtil.bytesToInt(Arrays.copyOfRange(appData, pos + 2, pos + 3));
            indefiniteData[index] = Arrays.copyOfRange(appData, pos, pos + 3 + len);
            pos = pos + 3 + len;
            index++;
        }
        return indefiniteData;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        int pos = 0;
        final int systemType = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        final int systemAddress = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        //skip len
        pos += 1;

        String systemDescription = "";
        if (pos < singleInfoObjectByte.length) {
            byte[] systemConfiguration = Arrays.copyOfRange(singleInfoObjectByte, pos, singleInfoObjectByte.length);
            systemDescription = new String(systemConfiguration, Charset.forName(ConstantKey.GB18030_CHARSET)).trim();
        }
        Map<String, Object> map = new HashMap<>(4);
        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.SYSTEM_DESCRIPTION, systemDescription);

        return map;
    }
}
