package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypeFlagParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;


/**
 * @author Kerry on 18/08/13
 * <p>
 * 上传建筑消防设施系统状态
 * <p>
 * 类型值 : 1
 * 方向 : 上行
 * <p>
 * <p>
 * 类型标志符(1字节)
 * 信息对象数日(1字节)
 * ------------------
 * 系统类型1(1字节)
 * 系统地址1(1字节)
 * 系统状态1(2字节)
 * 状态1发生时间(6字节)
 * ...................
 * 系统类型n(1字节)
 * 系统地址n(1字节)
 * 系统状态n(2字节)
 * 状态n发生时间(6字节)
 */
@TypeFlagMappingAnnotation("1")
public class UpBuildingFireSystemStatus extends AbstractTypeFlagParser {

    @Override
    public int getSingleDataInfoLength() {
        return 4;
    }

    @Override
    protected Map<String, Object> parserInfoObjectItem(int systemType, int systemAddress, int currentPosition, byte[] singleInfoObjectByte) {

        String systemStatus = HexUtil.byteArrayToHex(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 2));
        currentPosition += 2;

        Map<String, Object> map = new HashMap<>(4);

        map.put(TypeFlagKey.SYSTEM_TYPE, systemType);
        map.put(TypeFlagKey.SYSTEM_ADDRESS, systemAddress);
        map.put(TypeFlagKey.SYSTEM_STATUS, systemStatus);

        return calcDateTime(map, currentPosition, singleInfoObjectByte);
    }
}
