package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.ConstantKey;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.ITypeFlagParser;
import org.jetbrains.annotations.Nullable;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传用户信息传输装置配置情况
 * <p>
 * 类型: 26
 * 方向: 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象教日(1字节)
 * ---------------
 * 配置说明长度(1字节)
 * 配置说明(L字节)
 */

@TypeFlagMappingAnnotation("26")
public class UpUserInfoFireTransportConfiguration implements ITypeFlagParser {
    /**
     * 不定长,不生效
     *
     * @return
     */
    @Override
    public int getSingleDataInfoLength() {
        return 0;
    }

    @Nullable
    @Override
    public byte[][] indefiniteLength(int pos, int dataInfoCount, byte[] appData) {
        byte[][] indefiniteData = new byte[dataInfoCount][];
        int index = 0;
        while (index < dataInfoCount) {
            int len = HexUtil.bytesToInt(Arrays.copyOfRange(appData, pos, pos + 1));
            indefiniteData[index] = Arrays.copyOfRange(appData, pos, pos + 1 + len);
            pos = pos + 1 + len;
            index++;
        }
        return indefiniteData;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        //skip len,
        int pos = 1;
        String configDescription = "";
        if (pos < singleInfoObjectByte.length) {
            byte[] systemConfiguration = Arrays.copyOfRange(singleInfoObjectByte, pos, singleInfoObjectByte.length);
            configDescription = new String(systemConfiguration, Charset.forName(ConstantKey.GB18030_CHARSET)).trim();
        }
        return Collections.singletonMap(TypeFlagKey.CONFIG_DESCRIPTION, configDescription);
    }
}
