package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypFlagCalcDateParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传用户信息传输装置操作信息记录
 * <p>
 * 类型值: 24
 * 方向 : 上行
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节)
 * ------------------
 * 操作信息1(1字节)
 * 操作员编号1(1字节)
 * 操作1的记录时间(6字节)
 * ..................
 * 操作信息n(1字节)
 * 操作员编号n(1字节)
 * 操作n的记录时间(6字节)
 */

@TypeFlagMappingAnnotation("24")
public class UpUserInfoTransportOpetationRecord extends AbstractTypFlagCalcDateParser {
    @Override
    public int getSingleDataInfoLength() {
        return 2;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        int pos = 0;

        int operationInfo = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        int operatorNo = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, pos, pos + 1));
        pos += 1;

        Map<String, Object> map = new HashMap<>(4);
        map.put(TypeFlagKey.OPERATION_INFO, operationInfo);
        map.put(TypeFlagKey.OPERATOR_NO, operatorNo);

        return calcDateTime(map, pos, singleInfoObjectByte);
    }
}
