package com.vcarecity.gbtparser.typeflag.parser;

import com.vcarecity.gbt.annotation.TypeFlagMappingAnnotation;
import com.vcarecity.gbt.constant.TypeFlagKey;
import com.vcarecity.gbt.util.HexUtil;
import com.vcarecity.gbtparser.typeflag.AbstractTypFlagCalcDateParser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Kerry on 18/08/14
 * <p>
 * 上传用户信息传输装置软件版本
 * <p>
 * 类型值: 25
 * 方向 : 上行
 * <p>
 * <p>
 * 类型标志符(1字节)
 * 信息对象数目(1字节) = 1
 * -----------------
 * 主版本号(1字节)
 * 次版本号(1字节)
 */

@TypeFlagMappingAnnotation("25")
public class UpUserInfoTransportSoftwareVersion extends AbstractTypFlagCalcDateParser {

    /**
     * override, return 0
     *
     * @return
     */
    @Override
    public int dateTimeLen() {
        return 0;
    }

    @Override
    public int getSingleDataInfoLength() {
        return 2;
    }

    @Override
    public Map<String, Object> parserInfoObjectItem(int typeFlag, byte[] singleInfoObjectByte) {
        int currentPosition = 0;
        final int majorVersion = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        final int minorVersion = HexUtil.bytesToInt(Arrays.copyOfRange(singleInfoObjectByte, currentPosition, currentPosition + 1));
        currentPosition += 1;

        Map<String, Object> map = new HashMap<>(4);

        map.put(TypeFlagKey.MAJOR_VERSION, majorVersion);
        map.put(TypeFlagKey.MINOR_VERSION, minorVersion);

        return map;
    }
}
