package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

/**
 * @author Kerry on 18/10/22
 */

public class CreateDeviceCmdRequestDTO {


    /**
     * callbackUrl : https://server:port/callbackUri
     * deviceId : ********
     * command : {"method":"********","paras":{"paraName2":"paraValue2","paraName1":"paraValue1"},"serviceId":"********"}
     * expireTime: 0
     */
    @JsonProperty("deviceId")
    private String deviceId;

    @JsonProperty("command")
    private CommandEntity command;


    @JsonProperty("callbackUrl")
    private String callbackUrl;


    @JsonProperty("expireTime")
    private Integer expireTime;

    @JsonProperty("maxRetransmit")
    private Integer maxRetransmit;

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setCommand(CommandEntity command) {
        this.command = command;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public CommandEntity getCommand() {
        return command;
    }

    public Integer getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getMaxRetransmit() {
        return maxRetransmit;
    }

    public void setMaxRetransmit(Integer maxRetransmit) {
        this.maxRetransmit = maxRetransmit;
    }

    public static class CommandEntity {
        /**
         * method : ********
         * paras : {"paraName2":"paraValue2","paraName1":"paraValue1"}
         * serviceId : ********
         */
        @JsonProperty("method")
        private String method;

        @JsonProperty("paras")
        private Map<String, Object> paras;

        @JsonProperty("serviceId")
        private String serviceId;

        public void setMethod(String method) {
            this.method = method;
        }

        public void setParas(Map<String, Object> paras) {
            this.paras = paras;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getMethod() {
            return method;
        }

        public Map<String, Object> getParas() {
            return paras;
        }

        public String getServiceId() {
            return serviceId;
        }

        @Override
        public String toString() {
            return "CommandEntity{" +
                    "method='" + method + '\'' +
                    ", paras=" + paras +
                    ", serviceId='" + serviceId + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "CreateDeviceCmdReqDTO{" +
                "callbackUrl='" + callbackUrl + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", command=" + command +
                ", expireTime=" + expireTime +
                '}';
    }
}
