package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vcarecity.telnb.context.IResponseDataContext;

import java.util.Map;

/**
 * @author Kerry on 18/10/23
 */

public class CreateDeviceCmdResponseDTO implements IResponseDataContext {

    @JsonProperty("commandId")
    private String commandId;

    @JsonProperty("appId")
    private String appId;

    @JsonProperty("deviceId")
    private String deviceId;

    @JsonProperty("command")
    private CommandEntity command;

    @JsonProperty("callbackUrl")
    private String callbackUrl;

    @JsonProperty("expireTime")
    private Integer expireTime;

    @JsonProperty("status")
    private String status;

    @JsonProperty("creationTime")
    private String creationTime;

    @JsonProperty("executeTime")
    private String executeTime;

    @JsonProperty("platformIssuedTime")
    private String platformIssuedTime;

    @JsonProperty("deliveredTime")
    private String deliveredTime;

    public String getCommandId() {
        return commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public CommandEntity getCommand() {
        return command;
    }

    public void setCommand(CommandEntity command) {
        this.command = command;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public Integer getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCreationTime() {
        return creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public String getExecuteTime() {
        return executeTime;
    }

    public void setExecuteTime(String executeTime) {
        this.executeTime = executeTime;
    }

    public String getPlatformIssuedTime() {
        return platformIssuedTime;
    }

    public void setPlatformIssuedTime(String platformIssuedTime) {
        this.platformIssuedTime = platformIssuedTime;
    }

    public String getDeliveredTime() {
        return deliveredTime;
    }

    public void setDeliveredTime(String deliveredTime) {
        this.deliveredTime = deliveredTime;
    }

    @Override
    public String toString() {
        return "CreateDeviceCmdResponseDTO{" +
                "commandId='" + commandId + '\'' +
                ", appId='" + appId + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", command=" + command +
                ", callbackUrl='" + callbackUrl + '\'' +
                ", expireTime=" + expireTime +
                ", status='" + status + '\'' +
                ", creationTime='" + creationTime + '\'' +
                ", executeTime='" + executeTime + '\'' +
                ", platformIssuedTime='" + platformIssuedTime + '\'' +
                ", deliveredTime='" + deliveredTime + '\'' +
                '}';
    }

    public static class CommandEntity {
        /**
         * method : READ_DEVICE_STATUS
         * paras : {"vf":"7e7e7e83CA66376971100005ffffee0310e8"}
         * serviceId : ReadInfo
         */
        @JsonProperty("method")
        private String method;
        @JsonProperty("paras")
        private Map<String, Object> paras;
        @JsonProperty("serviceId")
        private String serviceId;

        public void setMethod(String method) {
            this.method = method;
        }

        public void setParas(Map<String, Object> paras) {
            this.paras = paras;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getMethod() {
            return method;
        }

        public Map<String, Object> getParas() {
            return paras;
        }

        public String getServiceId() {
            return serviceId;
        }

        @Override
        public String toString() {
            return "CommandEntity{" +
                    "method='" + method + '\'' +
                    ", paras=" + paras +
                    ", serviceId='" + serviceId + '\'' +
                    '}';
        }
    }
}