package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vcarecity.telnb.context.IResponseDataContext;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/10/23
 */

public class QueryDeviceCmdResponseDTO implements IResponseDataContext {
    @JsonProperty("pagination")
    private PaginationEntity pagination;

    @JsonProperty("data")
    private List<DataEntity> data;

    public PaginationEntity getPagination() {
        return pagination;
    }

    public void setPagination(PaginationEntity pagination) {
        this.pagination = pagination;
    }

    public List<DataEntity> getData() {
        return data;
    }

    public void setData(List<DataEntity> data) {
        this.data = data;
    }

    public static class PaginationEntity {
        /**
         * totalSize : 19
         * pageNo : 0
         * pageSize : 1000
         */
        @JsonProperty("totalSize")
        private Long totalSize;
        @JsonProperty("pageNo")
        private Long pageNo;
        @JsonProperty("pageSize")
        private Long pageSize;

        public void setTotalSize(Long totalSize) {
            this.totalSize = totalSize;
        }

        public void setPageNo(Long pageNo) {
            this.pageNo = pageNo;
        }

        public void setPageSize(Long pageSize) {
            this.pageSize = pageSize;
        }

        public Long getTotalSize() {
            return totalSize;
        }

        public Long getPageNo() {
            return pageNo;
        }

        public Long getPageSize() {
            return pageSize;
        }

        @Override
        public String toString() {
            return "PaginationEntity{" +
                    "totalSize=" + totalSize +
                    ", pageNo=" + pageNo +
                    ", pageSize=" + pageSize +
                    '}';
        }
    }


    public static class DataEntity {

        @JsonProperty("commandId")
        private String commandId;

        @JsonProperty("appId")
        private String appId;

        @JsonProperty("deviceId")
        private String deviceId;

        @JsonProperty("command")
        private CommandEntity command;

        @JsonProperty("callbackUrl")
        private String callbackUrl;

        @JsonProperty("expireTime")
        private Integer expireTime;

        @JsonProperty("status")
        private String status;

        @JsonProperty("result")
        private Map<String, Object> result;

        @JsonProperty("creationTime")
        private String creationTime;

        @JsonProperty("executeTime")
        private String executeTime;

        @JsonProperty("platformIssuedTime")
        private String platformIssuedTime;

        @JsonProperty("deliveredTime")
        private String deliveredTime;

        @JsonProperty("issuedTimes")
        private Integer issuedTimes;

        public String getCommandId() {
            return commandId;
        }

        public void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public String getAppId() {
            return appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getDeviceId() {
            return deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public CommandEntity getCommand() {
            return command;
        }

        public void setCommand(CommandEntity command) {
            this.command = command;
        }

        public String getCallbackUrl() {
            return callbackUrl;
        }

        public void setCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
        }

        public Integer getExpireTime() {
            return expireTime;
        }

        public void setExpireTime(Integer expireTime) {
            this.expireTime = expireTime;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Map<String, Object> getResult() {
            return result;
        }

        public void setResult(Map<String, Object> result) {
            this.result = result;
        }

        public String getCreationTime() {
            return creationTime;
        }

        public void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public String getExecuteTime() {
            return executeTime;
        }

        public void setExecuteTime(String executeTime) {
            this.executeTime = executeTime;
        }

        public String getPlatformIssuedTime() {
            return platformIssuedTime;
        }

        public void setPlatformIssuedTime(String platformIssuedTime) {
            this.platformIssuedTime = platformIssuedTime;
        }

        public String getDeliveredTime() {
            return deliveredTime;
        }

        public void setDeliveredTime(String deliveredTime) {
            this.deliveredTime = deliveredTime;
        }

        public Integer getIssuedTimes() {
            return issuedTimes;
        }

        public void setIssuedTimes(Integer issuedTimes) {
            this.issuedTimes = issuedTimes;
        }

        //OK
        public static class CommandEntity {
            @JsonProperty("serviceId")
            private String serviceId;

            @JsonProperty("method")
            private String method;

            @JsonProperty("paras")
            private Map<String, Object> paras;

            public String getServiceId() {
                return serviceId;
            }

            public void setServiceId(String serviceId) {
                this.serviceId = serviceId;
            }

            public String getMethod() {
                return method;
            }

            public void setMethod(String method) {
                this.method = method;
            }

            public Map<String, Object> getParas() {
                return paras;
            }

            public void setParas(Map<String, Object> paras) {
                this.paras = paras;
            }
        }

        @Override
        public String toString() {
            return "DataEntity{" +
                    "commandId='" + commandId + '\'' +
                    ", appId='" + appId + '\'' +
                    ", deviceId='" + deviceId + '\'' +
                    ", command=" + command +
                    ", callbackUrl='" + callbackUrl + '\'' +
                    ", expireTime=" + expireTime +
                    ", status='" + status + '\'' +
                    ", result=" + result +
                    ", creationTime='" + creationTime + '\'' +
                    ", executeTime='" + executeTime + '\'' +
                    ", platformIssuedTime='" + platformIssuedTime + '\'' +
                    ", deliveredTime='" + deliveredTime + '\'' +
                    ", issuedTimes=" + issuedTimes +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "QueryDeviceCmdResponseDTO{" +
                "pagination=" + pagination +
                ", data=" + data +
                '}';
    }
}
