package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vcarecity.telnb.context.IResponseDataContext;

import java.util.List;
import java.util.Map;

/**
 * @author KerryZhang
 * <p>
 * 查询设备信息返回
 */
public class QueryDeviceInfoResponseDTO implements IResponseDataContext {
    @JsonProperty("deviceId")
    private String deviceId;

    @JsonProperty("gatewayId")
    private String gatewayId;

    @JsonProperty("nodeType")
    private String nodeType;

    @JsonProperty("createTime")
    private String createTime;

    @JsonProperty("lastModifiedTime")
    private String lastModifiedTime;

    @JsonProperty("deviceInfo")
    private DeviceInfoEntity deviceInfo;

    private List<DeviceServiceEntity> services;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getGatewayId() {
        return gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getNodeType() {
        return nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getLastModifiedTime() {
        return lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public DeviceInfoEntity getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(DeviceInfoEntity deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public List<DeviceServiceEntity> getServices() {
        return services;
    }

    public void setServices(List<DeviceServiceEntity> services) {
        this.services = services;
    }

    @Override
    public String toString() {
        return "QueryDeviceInfoResponseDTO{" +
                "deviceId='" + deviceId + '\'' +
                ", gatewayId='" + gatewayId + '\'' +
                ", nodeType='" + nodeType + '\'' +
                ", createTime='" + createTime + '\'' +
                ", lastModifiedTime='" + lastModifiedTime + '\'' +
                ", deviceInfo=" + deviceInfo +
                ", services=" + services +
                '}';
    }

    public static class DeviceInfoEntity {
        @JsonProperty("nodeId")
        private String nodeId;

        @JsonProperty("name")
        private String name;

        @JsonProperty("description")
        private String description;

        @JsonProperty("manufacturerId")
        private String manufacturerId;

        @JsonProperty("manufacturerName")
        private String manufacturerName;

        @JsonProperty("mac")
        private String mac;

        @JsonProperty("location")
        private String location;

        @JsonProperty("deviceType")
        private String deviceType;

        @JsonProperty("model")
        private String model;

        @JsonProperty("swVersion")
        private String swVersion;

        @JsonProperty("fwVersion")
        private String fwVersion;

        @JsonProperty("hwVersion")
        private String hwVersion;

        @JsonProperty("protocolType")
        private String protocolType;

        @JsonProperty("bridgeId")
        private String bridgeId;

        @JsonProperty("status")
        private String status;

        @JsonProperty("statusDetail")
        private String statusDetail;

        @JsonProperty("mute")
        private String mute;


        @JsonProperty("supportedSecurity")
        private String supportedSecurity;

        @JsonProperty("isSecurity")
        private String isSecurity;

        @JsonProperty("signalStrength")
        private String signalStrength;


        @JsonProperty("sigVersion")
        private String sigVersion;

        @JsonProperty("serialNumber")
        private String serialNumber;


        @JsonProperty("batteryLevel")
        private String batteryLevel;
    }


    public static class DeviceServiceEntity {
        private String serviceId;
        private String serviceType;
        private ServiceInfoEntity serviceInfo;
        private Map<String, Object> data;
        private String eventTime;

        public String getServiceId() {
            return serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getServiceType() {
            return serviceType;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public ServiceInfoEntity getServiceInfo() {
            return serviceInfo;
        }

        public void setServiceInfo(ServiceInfoEntity serviceInfo) {
            this.serviceInfo = serviceInfo;
        }

        public Map<String, Object> getData() {
            return data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public String getEventTime() {
            return eventTime;
        }

        public void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public String toString() {
            return "DeviceServiceEntity{" +
                    "serviceId='" + serviceId + '\'' +
                    ", serviceType='" + serviceType + '\'' +
                    ", serviceInfo=" + serviceInfo +
                    ", data=" + data +
                    ", eventTime='" + eventTime + '\'' +
                    '}';
        }

        public static class ServiceInfoEntity {
            private List<ServiceInfoEntity> muteCmds;

            public List<ServiceInfoEntity> getMuteCmds() {
                return muteCmds;
            }

            public void setMuteCmds(List<ServiceInfoEntity> muteCmds) {
                this.muteCmds = muteCmds;
            }

            @Override
            public String toString() {
                return "ServiceInfoEntity{" +
                        "muteCmds=" + muteCmds +
                        '}';
            }
        }
    }
}
