package com.vcarecity.telnb.dto;

import com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.Nullable;

/**
 * @author Kerry on 18/10/22
 */

public class SubscribeRequestDTO {


    public enum NotifyType {
        /**
         * 绑定设备
         */
        BIND_DEVICE("bindDevice"),
        /**
         * 添加新设备
         */
        DEVICE_ADDED("deviceAdded"),
        /**
         * 设备信息变化
         */
        DEVICE_INFO_CHANGED("deviceInfoChanged"),
        /**
         * 设备数据变化
         */
        DEVICE_DATA_CHANGED("deviceDataChanged"),
        /**
         * 设备数据批量变化
         */
        DEVICE_DATAS_CHANGED("deviceDatasChanged"),
        /**
         * 删除设备
         */
        DEVICE_DELETED("deviceDeleted"),
        /**
         * 消息确认
         */
        MESSAGE_CONFIRM("messageConfirm"),
        /**
         * commandRsp
         */
        COMMAND_RSP("commandRsp"),
        /**
         * deviceEvent
         */
        DEVICE_EVENT("deviceEvent"),
        /**
         * serviceInfoChanged
         */
        SERVICE_INFO_CHANGED("serviceInfoChanged"),
        /**
         * ruleEvent
         */
        RULE_EVENT("ruleEvent"),
        /**
         * deviceModelAdded
         */
        DEVICE_MODEL_ADDED("deviceModelAdded"),
        /**
         * deviceModelDeleted
         */
        DEVICE_MODEL_DELETED("deviceModelDeleted"),
        /**
         * deviceDesiredPropertiesModifyStatusChanged
         */
        DEVICE_DESIRED_PROPERTIES_MODIFY_STATUS_CHANGED("deviceDesiredPropertiesModifyStatusChanged");

        private String name;

        NotifyType(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return name;
        }

        @Override
        public String toString() {
            return name;
        }

        @Nullable
        public static NotifyType toType(String name) {
            for (NotifyType value : values()) {
                if (value.name.equals(name)) {
                    return value;
                }
            }
            return null;
        }
    }

    private NotifyType notifyType;
    private String callbackUrl;
    private String appId;


    public NotifyType getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return "SubscribeRequestDTO{" +
                "notifyType=" + notifyType +
                ", callbackUrl='" + callbackUrl + '\'' +
                ", appId='" + appId + '\'' +
                '}';
    }
}
