package com.vcarecity.telnb.entity;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * Token 实体类
 *
 * @author KerryZhang
 */
public class TokenEntity implements Serializable {

    private static final long serialVersionUID = 86456464654664L;

    /**
     * expiresIn : 3600
     * scope : default
     * accessToken : b024e4dedb7b83f5dfa1ccaf35e7291c
     * tokenType : bearer
     * refreshToken : b66edff7d06534ee99361531d8f392cc
     */
    @JsonProperty("expiresIn")
    private Integer expiresIn;
    @JsonProperty("scope")
    private String scope;
    @JsonProperty("accessToken")
    private String accessToken;
    @JsonProperty("tokenType")
    private String tokenType;
    @JsonProperty("refreshToken")
    private String refreshToken;

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public String getScope() {
        return scope;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public String getTokenType() {
        return tokenType;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    @Override
    public String toString() {
        return "TokenEntity{" +
                "expiresIn=" + expiresIn +
                ", scope='" + scope + '\'' +
                ", accessToken='" + accessToken + '\'' +
                ", tokenType='" + tokenType + '\'' +
                ", refreshToken='" + refreshToken + '\'' +
                '}';
    }
}