package com.vcarecity.telnb.provider;

import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.service.TokenService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

/**
 * @author Kerry on 18/11/07
 */


@Component
@ConditionalOnProperty(value = "tel.nb.enable")
public class HttpHeaderProvider implements HeaderProvider {

    private final TokenService tokenService;
    private final TelNbProperties telNbProperties;

    public HttpHeaderProvider(TokenService tokenService, TelNbProperties telNbProperties) {
        this.tokenService = tokenService;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        String accessToken = tokenService.getAccessToken();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("app_key", telNbProperties.getAppId());
        httpHeaders.add("Authorization", "Bearer" + " " + accessToken);
        return httpHeaders;
    }
}
