package com.vcarecity.telnb.service;

import com.vcarecity.telnb.core.AbstractResponse;
import org.jetbrains.annotations.NotNull;

/**
 * @author KerryZhang
 * <p>
 * 数据收集
 */
public interface DataCollectService {


    /**
     * 查询单个设备信息
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 查询单个设备信息
     * </a>
     *
     * @param deviceId
     * @return
     */
    default AbstractResponse queryDeviceInfo(@NotNull String deviceId) {
        return queryDeviceInfo(deviceId, "imsi");
    }


    /**
     * 查询单个设备信息
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 查询单个设备信息
     * </a>
     *
     * @param deviceId
     * @param select   可选值: imsi
     * @return
     */
    AbstractResponse queryDeviceInfo(@NotNull String deviceId, String select);


}
