package com.vcarecity.telnb.service;

import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.RefreshDeviceKeyRequestDTO;
import com.vcarecity.telnb.dto.RegisteredDeviceRequestDTO;
import com.vcarecity.telnb.dto.UpdateDeviceInfoRequestDTO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * @author Kerry on 18/10/22
 * <p>
 * 设备管理
 *
 * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
 * 设备管理
 * </a>
 */

public interface DeviceManagerService {


    /**
     * 注册设备
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 注册设备
     * </a>
     *
     * @param registeredDevice
     * @return
     * @throws Exception
     */
    AbstractResponse registeredDevice(RegisteredDeviceRequestDTO registeredDevice) throws Exception;


    /**
     * 修改设备信息
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 修改设备信息
     * </a>
     *
     * @param deviceId
     * @param updateDeviceInfo
     * @return
     * @throws Exception
     */
    AbstractResponse updateDeviceInfo(@NotNull String deviceId, UpdateDeviceInfoRequestDTO updateDeviceInfo) throws Exception;


    /**
     * 删除设备
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 删除设备
     * </a>
     *
     * @param deviceId
     * @param cascade
     * @return
     */
    AbstractResponse deleteDevice(@NotNull String deviceId, @Nullable String cascade);


    /**
     * 查询设备激活状态
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 查询设备激活状态
     * </a>
     *
     * @param deviceId
     * @return
     */
    AbstractResponse queryDeviceActiveStatus(@NotNull String deviceId);


    /**
     * 刷新设备密钥
     *
     * <a href="https://180.101.147.208:8093/assets/docCenter/helpcenter/helpPortal/Portal/helpcenter.html?manualName=UserGuide_CMCC&docSite=CMCC&page=Overview&lang=zh&fake_Url=zh-cn_topic_0118669796.html">
     * 刷新设备密钥
     * </a>
     *
     * @param deviceId
     * @param refreshDeviceKey
     * @return
     * @throws Exception
     */
    AbstractResponse refreshDeviceKey(String deviceId, RefreshDeviceKeyRequestDTO refreshDeviceKey) throws Exception;


}
