package com.vcarecity.telnb.service.impl;

import com.vcarecity.telnb.context.IResponseDataContext;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.core.DataResponse;
import com.vcarecity.telnb.dto.SubscribeBatchQueryResponseDTO;
import com.vcarecity.telnb.dto.SubscribeRequestDTO;
import com.vcarecity.telnb.service.AdminService;
import com.vcarecity.telnb.service.SubscribeManagerService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Kerry on 18/11/07
 */

@Service
@ConditionalOnProperty(value = "tel.nb.enable")
public class AdminServiceImpl implements AdminService {

    private static final Logger logger = LoggerFactory.getLogger(AdminServiceImpl.class);

    private final SubscribeManagerService subscribeManagerService;

    public AdminServiceImpl(SubscribeManagerService subscribeManagerService) {
        this.subscribeManagerService = subscribeManagerService;
    }

    @Override
    public Object deleteAllUrl() {
        AbstractResponse abstractResponse = subscribeManagerService.batchQuerySubscribe(null, 0, 100);
        if (abstractResponse instanceof DataResponse) {
            IResponseDataContext data = ((DataResponse) abstractResponse).getData();
            if (data instanceof SubscribeBatchQueryResponseDTO) {
                SubscribeBatchQueryResponseDTO result = (SubscribeBatchQueryResponseDTO) data;
                List<SubscribeBatchQueryResponseDTO.SubscriptionDTO> subscriptions = result.getSubscriptions();
                List<AbstractResponse> responseList = new ArrayList<>(subscriptions.size());
                for (SubscribeBatchQueryResponseDTO.SubscriptionDTO subscription : subscriptions) {
                    AbstractResponse once = subscribeManagerService.deleteSubscribe(subscription.getSubscriptionId());
                    responseList.add(once);
                }
                return responseList;
            }
        }
        return null;
    }

    @Override
    public List<AbstractResponse> setDefaultUrl(@NotNull String baseHost) {
        baseHost = baseHost.trim();
        if (baseHost.endsWith("/")) {
            baseHost = baseHost.substring(0, baseHost.length() - 1);
        }
        List<SubscribeRequestDTO> dtoList = new ArrayList<>();
        SubscribeRequestDTO deviceInfoChanged = new SubscribeRequestDTO();
        deviceInfoChanged.setNotifyType(SubscribeRequestDTO.NotifyType.DEVICE_INFO_CHANGED);
        deviceInfoChanged.setCallbackUrl(baseHost + "/push/v1.0/deviceInfoChanged");
        dtoList.add(deviceInfoChanged);

        SubscribeRequestDTO deviceDeleted = new SubscribeRequestDTO();
        deviceDeleted.setNotifyType(SubscribeRequestDTO.NotifyType.DEVICE_DELETED);
        deviceDeleted.setCallbackUrl(baseHost + "/push/v1.0/deviceDeleted");
        dtoList.add(deviceDeleted);


        SubscribeRequestDTO deviceDataChanged = new SubscribeRequestDTO();
        deviceDataChanged.setNotifyType(SubscribeRequestDTO.NotifyType.DEVICE_DATA_CHANGED);
        deviceDataChanged.setCallbackUrl(baseHost + "/push/v1.0/deviceDataChanged");
        dtoList.add(deviceDataChanged);

        SubscribeRequestDTO commandRsp = new SubscribeRequestDTO();
        commandRsp.setNotifyType(SubscribeRequestDTO.NotifyType.COMMAND_RSP);
        commandRsp.setCallbackUrl(baseHost + "/push/v1.0/commandRsp");
        dtoList.add(commandRsp);

        SubscribeRequestDTO deviceAdded = new SubscribeRequestDTO();
        deviceAdded.setNotifyType(SubscribeRequestDTO.NotifyType.DEVICE_ADDED);
        deviceAdded.setCallbackUrl(baseHost + "/push/v1.0/deviceAdded");
        dtoList.add(deviceAdded);

        List<AbstractResponse> responseList = new ArrayList<>(dtoList.size());
        for (SubscribeRequestDTO dto : dtoList) {
            try {
                AbstractResponse abstractResponse = subscribeManagerService.subscribePlatformBusinessData(dto, null);
                responseList.add(abstractResponse);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }
        }
        return responseList;
    }
}
