package com.vcarecity.telnb.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vcarecity.telnb.constant.NbConstant;
import com.vcarecity.telnb.constant.TelUrlConstant;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.dto.CreateDeviceCmdRequestDTO;
import com.vcarecity.telnb.dto.CreateDeviceCmdResponseDTO;
import com.vcarecity.telnb.dto.QueryDeviceCmdResponseDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.provider.HeaderProvider;
import com.vcarecity.telnb.service.DownStreamService;
import com.vcarecity.telnb.util.ResponseHandleUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author KerryZhang
 */
@Service
@ConditionalOnProperty(value = "tel.nb.enable")
public class DownStreamServiceImpl implements DownStreamService {

    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final HeaderProvider headerProvider;
    private final TelNbProperties telNbProperties;

    public DownStreamServiceImpl(RestTemplate restTemplate, ObjectMapper objectMapper, HeaderProvider headerProvider, TelNbProperties telNbProperties) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.headerProvider = headerProvider;
        this.telNbProperties = telNbProperties;
    }

    @Override
    public AbstractResponse createDeviceCmd(CreateDeviceCmdRequestDTO createDeviceCmd) throws JsonProcessingException {

        String value = objectMapper.writeValueAsString(createDeviceCmd);

        HttpEntity<String> entity = new HttpEntity<>(value, headerProvider.getAppJsonHeader());

        ResponseEntity<String> response = restTemplate.postForEntity(TelUrlConstant.CREATE_DEVICE_CMD, entity, String.class);

        return ResponseHandleUtil.responseDataHandler(response, CreateDeviceCmdResponseDTO.class);
    }

    @Override
    public AbstractResponse queryDeviceCmd(@NotNull String deviceId, Integer pageNo, Integer pageSize, String startTime, String endTime) {
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 1000;
        }
        Map<String, Object> uris = new HashMap<>(8);
        uris.put(NbConstant.KEY_4_APP_ID, telNbProperties.getAppId());
        uris.put("deviceId", deviceId);
        uris.put("pageNo", pageNo);
        uris.put("pageSize", pageSize);
        uris.put("startTime", startTime);
        uris.put("endTime", endTime);

        HttpEntity<String> entity = new HttpEntity<>(headerProvider.getAppJsonHeader());

        ResponseEntity<String> response = restTemplate.exchange(TelUrlConstant.QUERY_DEVICE_CMD, HttpMethod.GET, entity, String.class, uris);
        return ResponseHandleUtil.responseDataHandler(response, QueryDeviceCmdResponseDTO.class);

    }
}
