package com.vcarecity.telnb.service.impl;

import com.vcarecity.telnb.api.AddDeviceBean;
import com.vcarecity.telnb.constant.NbConstant;
import com.vcarecity.telnb.core.AbstractResponse;
import com.vcarecity.telnb.core.DataResponse;
import com.vcarecity.telnb.dto.RegisteredDeviceRequestDTO;
import com.vcarecity.telnb.dto.RegisteredDeviceResponseDTO;
import com.vcarecity.telnb.dto.UpdateDeviceInfoRequestDTO;
import com.vcarecity.telnb.properties.TelNbProperties;
import com.vcarecity.telnb.service.DataCollectService;
import com.vcarecity.telnb.service.DeviceManagerService;
import com.vcarecity.telnb.service.NbDeviceApiService;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

/**
 * @author Kerry on 18/11/07
 */

@Service
@ConditionalOnProperty(value = "tel.nb.enable")
public class NbDeviceApiServiceImpl implements NbDeviceApiService {

    private final DeviceManagerService deviceManagerService;
    private final DataCollectService dataCollectService;
    private final TelNbProperties telNbProperties;

    public NbDeviceApiServiceImpl(DeviceManagerService deviceManagerService, DataCollectService dataCollectService, TelNbProperties telNbProperties) {
        this.deviceManagerService = deviceManagerService;
        this.dataCollectService = dataCollectService;
        this.telNbProperties = telNbProperties;
    }


    @Override
    public AbstractResponse addDevice(AddDeviceBean device) throws Exception {
        RegisteredDeviceRequestDTO reg = new RegisteredDeviceRequestDTO();
        reg.setNodeId(device.getImei());
        reg.setVerifyCode(device.getImei());
        reg.setEndUserId(device.getImsi());
        reg.setSecure(device.getSecure());
        reg.setTimeout(device.getTimeout());
        reg.setPsk(device.getPsk());

        AbstractResponse regResponse = deviceManagerService.registeredDevice(reg);
        if (regResponse.getHttpCode() == HttpStatus.OK.value()) {

            @SuppressWarnings("unchecked")
            DataResponse<RegisteredDeviceResponseDTO> regResponseData = (DataResponse<RegisteredDeviceResponseDTO>) regResponse;
            RegisteredDeviceResponseDTO data = regResponseData.getData();
            String deviceId = data.getDeviceId();

            UpdateDeviceInfoRequestDTO updateInfo = new UpdateDeviceInfoRequestDTO();

            if (device.getUnitNo() == null || device.getUnitNo().length() == 0) {
                updateInfo.setName(device.getImei());
            } else {
                updateInfo.setName(device.getUnitNo());
            }

            updateInfo.setManufacturerName(telNbProperties.getManufacturerName());
            updateInfo.setManufacturerId(telNbProperties.getManufacturerId());
            updateInfo.setDeviceType(telNbProperties.getDeviceType());
            updateInfo.setModel(telNbProperties.getModel());

            updateInfo.setProtocolType(NbConstant.PROTOCOL_TYPE);

            updateInfo.setRegion(device.getRegion());
            updateInfo.setTimezone(device.getTimezone());
            updateInfo.setOrganization(device.getOrganization());
            updateInfo.setSecure(device.getSecure());

            AbstractResponse updateResponse = deviceManagerService.updateDeviceInfo(deviceId, updateInfo);

            if (updateResponse.getHttpCode() == HttpStatus.NO_CONTENT.value()) {
                return updateResponse;
            }
            return deviceManagerService.deleteDevice(deviceId, "");
        }
        return regResponse;
    }

    @Override
    public AbstractResponse deleteDeviceById(@NotNull String deviceId) {
        return deviceManagerService.deleteDevice(deviceId, "");
    }

    @Override
    public AbstractResponse queryDeviceInfo(@NotNull String deviceId) {
        return dataCollectService.queryDeviceInfo(deviceId);
    }
}
