/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.seaweedfs.util;

import com.ejlchina.okhttps.FastjsonMsgConvertor;
import com.ejlchina.okhttps.HTTP;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.internal.AsyncHttpTask;
import com.vcarecity.seaweedfs.respone.Assign;
import com.vcarecity.seaweedfs.respone.Delete;
import com.vcarecity.seaweedfs.respone.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SeaweedFSUtil {
    public static String protocol;
    public static String host;
    public static String baseutl;
    public static HTTP http;

    public SeaweedFSUtil() {
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream in = loader.getResourceAsStream("seaweedFS.properties");
        try {
            properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        protocol = properties.getProperty("seaweedFS.protocol");
        host = properties.getProperty("seaweedFS.host");
        String timeoutStr = properties.getProperty("seaweedFS.timeout");
        baseutl = protocol + "://" + host;
        http = HTTP.builder().baseUrl(baseutl).addMsgConvertor((MsgConvertor)new FastjsonMsgConvertor()).build();
    }

    public static Assign getFid() {
        Assign assign = (Assign)http.sync(baseutl + "/dir/assign").get().getBody().toBean(Assign.class);
        return assign;
    }

    public static Upload upload(String filename) throws IOException {
        Assign assign = SeaweedFSUtil.getFid();
        String fileurl = protocol + "://" + assign.getUrl() + "/" + assign.getFid();
        System.out.println("\u6587\u4ef6URL\uff1a" + fileurl);
        Upload upload = (Upload)((AsyncHttpTask)((AsyncHttpTask)http.async(fileurl).bodyType("multipart/form")).addFilePara("field-name", filename)).post().getResult().getBody().toBean(Upload.class);
        upload.setFileurl(fileurl);
        return upload;
    }

    public static Delete delete(String fileurl) throws IOException {
        Delete del = (Delete)http.async(fileurl).delete().getResult().getBody().toBean(Delete.class);
        return del;
    }

    public static void main(String[] args) throws Exception {
        new SeaweedFSUtil();
        String fileurl = SeaweedFSUtil.upload("D:\\tmp\\0002.png").getFileurl();
        System.out.println("\u6587\u4ef6URL\uff1a" + fileurl);
        SeaweedFSUtil.delete(fileurl);
    }
}

