/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.seaweedfs.util;

import com.ejlchina.okhttps.FastjsonMsgConvertor;
import com.ejlchina.okhttps.HTTP;
import com.ejlchina.okhttps.MsgConvertor;
import com.ejlchina.okhttps.internal.AsyncHttpTask;
import com.vcarecity.seaweedfs.respone.Assign;
import com.vcarecity.seaweedfs.respone.Delete;
import com.vcarecity.seaweedfs.respone.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SeaweedFSUtil {
    public String protocol;
    public String host;
    public String baseutl;
    public HTTP http;

    public SeaweedFSUtil() {
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream in = loader.getResourceAsStream("seaweedFS.properties");
        try {
            properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.protocol = properties.getProperty("seaweedFS.protocol");
        this.host = properties.getProperty("seaweedFS.host");
        String timeoutStr = properties.getProperty("seaweedFS.timeout");
        this.baseutl = this.protocol + "://" + this.host;
        this.http = HTTP.builder().baseUrl(this.baseutl).addMsgConvertor((MsgConvertor)new FastjsonMsgConvertor()).build();
    }

    public Assign getFid() {
        Assign assign = (Assign)this.http.sync(this.baseutl + "/dir/assign").get().getBody().toBean(Assign.class);
        return assign;
    }

    public Upload upload(String filename) throws IOException {
        Assign assign = this.getFid();
        String fileurl = this.protocol + "://" + assign.getUrl() + "/" + assign.getFid();
        System.out.println("\u6587\u4ef6URL\uff1a" + fileurl);
        Upload upload = (Upload)((AsyncHttpTask)((AsyncHttpTask)this.http.async(fileurl).bodyType("multipart/form")).addFilePara("field-name", filename)).post().getResult().getBody().toBean(Upload.class);
        upload.setFileurl(fileurl);
        return upload;
    }

    public Delete delete(String fileurl) throws IOException {
        Delete del = (Delete)this.http.async(fileurl).delete().getResult().getBody().toBean(Delete.class);
        return del;
    }

    public static void main(String[] args) throws Exception {
        SeaweedFSUtil sf = new SeaweedFSUtil();
        String fileurl = sf.upload("D:\\tmp\\0002.png").getFileurl();
        System.out.println("\u6587\u4ef6URL\uff1a" + fileurl);
        sf.delete(fileurl);
    }
}

