/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.hmgasresolve.converter;

import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.hmgasresolve.constant.FlamGasCmd;
import com.vcarecity.hmgasresolve.constant.FlamGasCmdParamDown;
import com.vcarecity.hmgasresolve.constant.FlamGasParamType;
import com.vcarecity.hmnbcommon.context.HmDataTypeValueBean;
import org.jetbrains.annotations.Nullable;

public class FlamgasKeyCodeConverter {
    @Nullable
    public static String userIntToStringKeyConverter(Integer type) {
        if (type == null) {
            return null;
        }
        for (FlamGasParamType value : FlamGasParamType.values()) {
            if (type.intValue() != value.getType()) continue;
            return value.getValue();
        }
        return null;
    }

    @Nullable
    public static Integer userStringToIntKeyConverter(String key) {
        if (key == null || key.trim().length() == 0) {
            return null;
        }
        for (FlamGasParamType value : FlamGasParamType.values()) {
            if (!key.equals(value.getValue())) continue;
            return value.getType();
        }
        return null;
    }

    @Nullable
    public static String userTypeIntTotStringKey(Integer type) {
        FlamGasCmd[] values;
        if (type == null) {
            return null;
        }
        for (FlamGasCmd value : values = FlamGasCmd.values()) {
            if (type.intValue() != value.getCmd()) continue;
            return value.getValue();
        }
        return null;
    }

    public static String generateFlamGasDownStreamData(int id, @Nullable Object data) {
        byte[] bs;
        FlamGasCmdParamDown[] values = FlamGasCmdParamDown.values();
        FlamGasCmdParamDown select = null;
        for (FlamGasCmdParamDown value : values) {
            if (id != value.getCmd()) continue;
            select = value;
            break;
        }
        if (select == null) {
            throw new RuntimeException("do not support this id = " + id + ". with data = " + data);
        }
        if (data == null) {
            bs = new byte[select.getDataLen()];
            for (int i = 0; i < select.getDataLen(); ++i) {
                bs[i] = -1;
            }
        } else {
            bs = HexUtil.intToByteArray((int)Integer.parseInt(data.toString()), (int)select.getDataLen());
        }
        bs = HexUtil.concatAll((byte[][])new byte[][]{HexUtil.intToByteArray((int)select.getParamType(), (int)1), HexUtil.intToByteArray((int)bs.length, (int)2), bs});
        bs = HexUtil.concatAll((byte[][])new byte[][]{HexUtil.intToByteArray((int)id, (int)1), HexUtil.intToByteArray((int)bs.length, (int)2), bs});
        return HexUtil.byteArrayToHex((byte[])bs);
    }

    public static HmDataTypeValueBean.HmDataTLVBean<String> convertSystemParamCodec(int paramType, byte[] value) {
        throw new RuntimeException("flam gas has not no system impl, please call user param!");
    }

    public static HmDataTypeValueBean.HmDataTLVBean<String> convertUserParamCodec(int paramType, byte[] value) {
        HmDataTypeValueBean.HmDataTLVBean hb = new HmDataTypeValueBean.HmDataTLVBean();
        hb.setType(paramType);
        int i = HexUtil.byteArrayToInt((byte[])value);
        hb.setValue((Object)String.valueOf(i));
        return hb;
    }
}

