/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.dtu.parser;

import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.util.CrcUtil;
import com.vcarecity.dtucommon.constant.DtuProtocolConfig;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFrameParser {
    private static Logger logger = LoggerFactory.getLogger(BaseFrameParser.class);
    private byte[] dataBodyBody;

    public BaseJsonViewBean baseParser(byte[] frameData) {
        int calcCrcCode;
        int crcCode;
        int dataLen;
        byte[] dateLenByte;
        int pos = 0;
        byte[] maskByte = Arrays.copyOf(frameData, DtuProtocolConfig.DTU_MASK_LEN);
        if (!Arrays.equals(DtuProtocolConfig.DTU_MASK, maskByte)) {
            logger.debug("frame mask not equals 7e7e7e,data=[{}]", (Object)HexUtil.byteArrayToHex((byte[])frameData));
            return null;
        }
        byte[] deviceIdByte = Arrays.copyOfRange(frameData, pos += maskByte.length, pos + 6);
        byte[] funCodeByte = Arrays.copyOfRange(frameData, pos += deviceIdByte.length, pos + 1);
        pos += funCodeByte.length;
        int funCode = HexUtil.byteArrayToInt((byte[])funCodeByte);
        if ((pos += (dateLenByte = Arrays.copyOfRange(frameData, pos, pos + 2)).length) + (dataLen = HexUtil.byteArrayToInt((byte[])dateLenByte)) + 1 != frameData.length) {
            logger.debug("frame error,please check frame length and actual length,data=[{}]", (Object)HexUtil.byteArrayToHex((byte[])frameData));
            return null;
        }
        this.dataBodyBody = Arrays.copyOfRange(frameData, pos, pos + dataLen);
        if ((crcCode = HexUtil.byteArrayToInt((byte[])Arrays.copyOfRange(frameData, pos += this.dataBodyBody.length, pos + 1))) != (calcCrcCode = HexUtil.byteToInt((byte)CrcUtil.validate((byte[])frameData, (int)maskByte.length, (int)pos)))) {
            logger.debug("CRC ERROR,Calc={},data=[{}]", (Object)calcCrcCode, (Object)HexUtil.byteArrayToHex((byte[])frameData));
            return null;
        }
        BaseJsonViewBean communicate = new BaseJsonViewBean();
        communicate.setUnitNo(HexUtil.byteArrayToHex((byte[])deviceIdByte));
        communicate.setFunctionWord(Integer.valueOf(funCode));
        communicate.setEnable(Integer.valueOf(0));
        communicate.setEquipmentNo(Integer.valueOf(0));
        return communicate;
    }

    public byte[] getDataBodyBody() {
        return this.dataBodyBody;
    }
}

