/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.dtu.service;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.service.sub.IConverter;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConverter
implements IConverter {
    public byte[] convertMessage(BaseJsonViewBean message) throws NoRequireKeyException {
        Integer sn = message.getSn();
        Integer equipmentNo = message.getEquipmentNo();
        byte[] body = this.customSnAndEquipmentNo(sn, equipmentNo);
        List dataItems = message.getDataItems();
        byte[] bodyItem = this.iteratorDataItems(sn, equipmentNo, dataItems);
        body = HexUtil.concatAll((byte[][])new byte[][]{body, bodyItem});
        return body;
    }

    @NotNull
    protected byte[] iteratorDataItems(Integer sn, Integer equipmentNo, List<BaseJsonViewBean.DataItemDTO> list) throws NoRequireKeyException {
        byte[] body = new byte[]{};
        for (BaseJsonViewBean.DataItemDTO dataItemDTO : list) {
            byte[] bytes = this.convertItemBody(dataItemDTO.getId(), dataItemDTO.getData());
            if (bytes == null) continue;
            body = HexUtil.concatAll((byte[][])new byte[][]{body, bytes});
        }
        return body;
    }

    protected final byte[] defaultSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        if (sn == null) {
            sn = 0;
        }
        if (equipmentNo == null) {
            equipmentNo = 0;
        }
        return HexUtil.concatAll((byte[][])new byte[][]{HexUtil.intToByteArray((Object)sn, (int)2), HexUtil.intToByteArray((Object)equipmentNo, (int)1)});
    }

    @NotNull
    protected byte[] customSnAndEquipmentNo(Integer sn, Integer equipmentNo) {
        return this.defaultSnAndEquipmentNo(sn, equipmentNo);
    }

    public byte[] itemBodyConverter(Integer sn, Integer equipmentNo, Integer id, Map<String, Object> data) throws NoRequireKeyException {
        byte[] body = this.customSnAndEquipmentNo(sn, equipmentNo);
        byte[] temp = HexUtil.intToByteArray((Object)id, (int)2);
        body = HexUtil.concatAll((byte[][])new byte[][]{body, temp});
        return HexUtil.concatAll((byte[][])new byte[][]{body, this.convertItemBody(id, data)});
    }

    @NotNull
    public abstract byte[] convertItemBody(@NotNull Integer var1, Map<String, Object> var2) throws NoRequireKeyException;
}

