/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.dtu.service.impl;

import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.common.frame.IDtuFrameParser;
import com.vcarecity.common.service.IParserFrameService;
import com.vcarecity.common.util.CopyUtil;
import com.vcarecity.dtu.parser.BaseFrameParser;
import com.vcarecity.dtu.upload.heartbeat.HeartBeatParser;
import com.vcarecity.dtu.upload.login.BatteryLoginParser;
import com.vcarecity.dtu.upload.login.LoginParser;
import com.vcarecity.dtu.upload.read.ReadData;
import com.vcarecity.dtu.upload.report.ReportData;
import com.vcarecity.dtu.upload.request.PollRequest87;
import com.vcarecity.dtu.upload.write.WriteData;
import com.vcarecity.dtu.upload.write.WriteDataCommon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ParserFrameServiceImpl
implements IParserFrameService<BaseJsonViewBean> {
    protected static ConcurrentHashMap<String, IDtuFrameParser> PARSER_CACHE = new ConcurrentHashMap(64);

    public BaseJsonViewBean parserFrame(byte[] frameData) {
        BaseFrameParser baseFrameParser = new BaseFrameParser();
        BaseJsonViewBean communicate = baseFrameParser.baseParser(frameData);
        if (communicate == null) {
            return null;
        }
        communicate.setEquipmentNo(Integer.valueOf(0));
        communicate.setSn(Integer.valueOf(0));
        switch (communicate.getFunctionWord()) {
            case 130: {
                LoginParser parser = new LoginParser();
                List loginDto = parser.parserDataItem(130, baseFrameParser.getDataBodyBody());
                communicate.setEquipmentNo(Integer.valueOf(0));
                communicate.setDataItems(loginDto);
                break;
            }
            case 134: {
                BatteryLoginParser parser = new BatteryLoginParser();
                List batteryLoginDto = parser.parserDataItem(134, baseFrameParser.getDataBodyBody());
                communicate.setEquipmentNo(Integer.valueOf(0));
                communicate.setDataItems(batteryLoginDto);
                break;
            }
            case 132: {
                HeartBeatParser hbParser = new HeartBeatParser();
                List hbItem = hbParser.parserDataItem(132, baseFrameParser.getDataBodyBody());
                communicate.setDataItems(hbItem);
                break;
            }
            case 135: {
                PollRequest87 parser = new PollRequest87();
                List poll = parser.parserDataItem(135, baseFrameParser.getDataBodyBody());
                communicate.setDataItems(poll);
                return CopyUtil.toBatteryBean((BaseJsonViewBean)communicate);
            }
            case 144: 
            case 160: 
            case 176: {
                communicate = this.parserBody(communicate, baseFrameParser.getDataBodyBody(), communicate.getFunctionWord());
                break;
            }
        }
        return communicate;
    }

    private BaseJsonViewBean parserBody(BaseJsonViewBean communicate, byte[] dataBody, int funCode) {
        int pos = 0;
        int sn = HexUtil.byteArrayToInt((byte[])Arrays.copyOf(dataBody, 2));
        int equipmentNo = HexUtil.byteArrayToInt((byte[])Arrays.copyOfRange(dataBody, pos += 2, pos + 1));
        byte[] dataStatus = Arrays.copyOfRange(dataBody, ++pos, dataBody.length);
        communicate.setSn(Integer.valueOf(sn));
        communicate.setEquipmentNo(Integer.valueOf(equipmentNo));
        if (dataStatus.length < 2) {
            return communicate;
        }
        List<BaseJsonViewBean.DataItemDTO> dataItemDTOS = this.parserItemData(dataStatus, funCode);
        communicate.setDataItems(dataItemDTOS);
        return communicate;
    }

    private List<BaseJsonViewBean.DataItemDTO> parserItemData(byte[] dataStatus, int funCode) {
        int pos = 0;
        ArrayList<BaseJsonViewBean.DataItemDTO> list = new ArrayList<BaseJsonViewBean.DataItemDTO>();
        while (pos < dataStatus.length) {
            int dataType = HexUtil.byteArrayToInt((byte[])Arrays.copyOfRange(dataStatus, pos, pos + 2));
            pos += 2;
            IDtuFrameParser parser = this.findClass(funCode, dataType);
            if (parser == null) continue;
            int dataLen = parser.getCurrentCodeLength();
            byte[] data = dataLen == -1 ? Arrays.copyOfRange(dataStatus, pos, dataStatus.length) : Arrays.copyOfRange(dataStatus, pos, pos + dataLen);
            pos += data.length;
            List dataItemDTOList = parser.parserDataItem(dataType, data);
            if (dataItemDTOList == null) {
                list.addAll(Collections.emptyList());
                continue;
            }
            list.addAll(dataItemDTOList);
        }
        return list;
    }

    private IDtuFrameParser findClass(int funCode, Object type) {
        switch (funCode) {
            case 176: {
                return this.newParserInstance(ReportData.class.getName(), type);
            }
            case 160: {
                IDtuFrameParser parser = this.newParserInstance(WriteData.class.getName(), type);
                if (parser == null) {
                    parser = new WriteDataCommon();
                }
                return parser;
            }
            case 144: {
                return this.newParserInstance(ReadData.class.getName(), type);
            }
        }
        return null;
    }

    private IDtuFrameParser newParserInstance(String baseName, Object name) {
        String cn = baseName + name.toString();
        IDtuFrameParser parser = PARSER_CACHE.get(cn);
        if (parser != null) {
            return parser;
        }
        try {
            Class<?> clazz = Class.forName(cn);
            parser = (IDtuFrameParser)clazz.newInstance();
            PARSER_CACHE.put(cn, parser);
            return parser;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setParserCache(ConcurrentHashMap<String, IDtuFrameParser> parserCache) {
        PARSER_CACHE = parserCache;
    }
}

