package com.vcarecity.xml;


import com.vcarecity.xml.config.XmlGwConfig;
import com.vcarecity.xml.listener.IPropertiesListener;
import com.vcarecity.xml.loader.XmlLoader;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;

/**
 * @author Kerry on 18/09/14
 */

public class GwDtuXmlApplication {

    public static void run(@Nullable IPropertiesListener propertiesListener) throws IOException {
        if (propertiesListener != null) {
            propertiesListener.beforeLoad();
        }
        XmlLoader.loadXmlFile(XmlGwConfig.getXmlPath());
        if (propertiesListener != null) {
            propertiesListener.afterLoad();
        }
    }


    public static void run(String xmlPath) throws IOException {
        run(xmlPath, null);
    }

    /**
     * 初始化
     */
    public static void run(String xmlPath, @Nullable IPropertiesListener propertiesListener) throws IOException {
        if (propertiesListener != null) {
            propertiesListener.beforeLoad();
        }
        XmlLoader.loadXmlFile(xmlPath);
        if (propertiesListener != null) {
            propertiesListener.afterLoad();
        }
    }
}
