package com.vcarecity.xml.json;

import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.context.MqProtocolBean;
import com.vcarecity.xml.config.XmlGwConfig;
import com.vcarecity.xml.xml.ProtocolInstance;
import com.vcarecity.xml.xml.bean.FrameDetailBean;
import com.vcarecity.xml.xml.entity.VcarecityPD;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry
 * date 2017/10/9
 * desp 用Jackson生成JSON
 */

public class ByteToJackson implements IByteToJsonConverter<MqProtocolBean> {
    @Override
    public MqProtocolBean createJsonObject(Map<String, FrameDetailBean> headMap, List<List<Map>> dtiVals, int funCodeTen, Map<String, String> fieldMap) {

        VcarecityPD pd = ProtocolInstance.get().getVcareType();

        MqProtocolBean protocolBean = new MqProtocolBean();
        protocolBean.setGatewayNo(String.valueOf(XmlGwConfig.getGatewayNo()));

        if (null != pd.getFAddress()) {
            FrameDetailBean bean = headMap.get(pd.getFAddress().getName());
            if (bean != null) {
                protocolBean.setfDeviceNo(HexUtil.byteArrayToHex(bean.getData()));
            }
        }

        if (null != pd.getTAddress()) {
            FrameDetailBean bean = headMap.get(pd.getTAddress().getName());
            if (bean != null) {
                protocolBean.setUnitNo(HexUtil.byteArrayToHex(bean.getData()).toUpperCase());
            }
        }

        protocolBean.setProtocolNo("" + pd.getProtocalNo());
        protocolBean.setFunctionWord("" + funCodeTen);

        String mpNo;
        mpNo = fieldMap.get(DataTypeConstant.MP);
        if (mpNo == null) {
            mpNo = "0";
        }
        protocolBean.setEquipmentNo(mpNo);


        if (fieldMap.get(DataTypeConstant.SN) != null) {
            protocolBean.setSn(fieldMap.get(DataTypeConstant.SN));
        }
        if (!dtiVals.isEmpty()) {
            List<Map> contentList = new ArrayList();
            for (List<Map> list : dtiVals) {
                contentList.addAll(list);
            }
            protocolBean.setDataItems(contentList);
            protocolBean.setEnable("0");

        } else {
            protocolBean.setEnable("1");
        }
        return protocolBean;
    }
}
