package com.vcarecity.xml.json;

import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.config.XmlGwConfig;
import com.vcarecity.xml.xml.ProtocolInstance;
import com.vcarecity.xml.xml.bean.FrameDetailBean;
import com.vcarecity.xml.xml.entity.VcarecityPD;
import net.sf.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry
 * date 2017/10/9
 * desp 用JSONObject生成JSON
 */

public class ByteToJsonObject implements IByteToJsonConverter<JSONObject> {
    @Override
    public JSONObject createJsonObject(Map<String, FrameDetailBean> headMap, List<List<Map>> dtiVals, int funCodeTen, Map<String, String> fieldMap) {

        VcarecityPD pd = ProtocolInstance.get().getVcareType();

        JSONObject json = new JSONObject();

        json.put(DataTypeConstant.GatewayNo, XmlGwConfig.getGatewayNo());

        if (null != pd.getFAddress()) {
            FrameDetailBean bean = headMap.get(pd.getFAddress().getName());
            if (bean != null) {
                json.put(DataTypeConstant.FDeviceNo, HexUtil.byteArrayToHex(bean.getData()));
            }
        }

        if (null != pd.getTAddress()) {
            FrameDetailBean bean = headMap.get(pd.getTAddress().getName());
            if (bean != null) {
                json.put(DataTypeConstant.UnitNo, HexUtil.byteArrayToHex(bean.getData()).toLowerCase());
            }
        }

        json.put(DataTypeConstant.ProtocolNo, "" + ProtocolInstance.get().getVcareType().getProtocalNo());
        json.put(DataTypeConstant.AFN, "" + funCodeTen);

        String mpNo;
        mpNo = fieldMap.get(DataTypeConstant.MP);
        if (mpNo == null) {
            mpNo = "0";
        }
        //equipmentNo
        json.put(DataTypeConstant.MP, mpNo);


        if (fieldMap.get(DataTypeConstant.SN) != null) {
            //sn
            json.put(DataTypeConstant.SN, fieldMap.get(DataTypeConstant.SN));
        }

        if (!dtiVals.isEmpty()) {
            List<Map> contentList = new ArrayList();
            for (List<Map> list : dtiVals) {
                contentList.addAll(list);
            }
            json.put(DataTypeConstant.DataItems, contentList);
            json.put(DataTypeConstant.ENABLE, "0");
        } else {
            json.put(DataTypeConstant.DataItems, null);
            json.put(DataTypeConstant.ENABLE, "1");

        }
        return json;
    }
}
