package com.vcarecity.xml.loader;

import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.xml.ProtocolHelper;
import com.vcarecity.xml.xml.ProtocolInstance;
import com.vcarecity.xml.xml.XMLHelper;
import com.vcarecity.xml.xml.entity.AFN;
import com.vcarecity.xml.xml.entity.DItem;
import com.vcarecity.xml.xml.entity.DataElementType;
import com.vcarecity.xml.xml.entity.VcarecityPD;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class XmlLoader {


    public static void loadXmlFile(String xmlFilePath) throws IOException {


        File file = new File(xmlFilePath);
        if (!file.exists()) {
            throw new FileNotFoundException("'" + file.getName() + "'");
        }
        VcarecityPD vcareType = initXML(file);
        Map<Integer, DItem> ditMap = initSeqMap(vcareType);
        Map<Integer, List<AFN>> downAFNs = initDownAFNs(vcareType);
        Map<Integer, AFN> upAfns = initUpAFNs(vcareType);
        Map<Integer, Map<Integer, DataElementType>> dataElementMap = initDataElementMap(upAfns);

        ProtocolHelper protocolHelper = new ProtocolHelper(vcareType, ditMap, downAFNs, upAfns, dataElementMap);

        ProtocolInstance.setProtocolInstance(protocolHelper);
    }

    private static VcarecityPD initXML(File xmlUri) {
        XMLHelper helper = new XMLHelper(VcarecityPD.class, AFN.class, DataElementType.class);
        String xmlIn = helper.readToString(xmlUri);
        return helper.fromXml(xmlIn);
    }


    private static Map<Integer, DItem> initSeqMap(VcarecityPD vcareType) {
        Map<Integer, DItem> ditMap = new ConcurrentHashMap<>(32);

        if (vcareType.getFAddress() != null) {
            int addSeq = vcareType.getFAddress().getSeq();
            ditMap.put(addSeq, vcareType.getFAddress());
        }
        if (vcareType.getTAddress() != null) {
            int addSeq = vcareType.getTAddress().getSeq();
            ditMap.put(addSeq, vcareType.getTAddress());
        }
        if (vcareType.getFunction() != null) {
            int funSeq = vcareType.getFunction().getSeq();
            ditMap.put(funSeq, vcareType.getFunction());
        }

        if (vcareType.getDataLen() != null) {
            int lenSeq = vcareType.getDataLen().getSeq();
            ditMap.put(lenSeq, vcareType.getDataLen());
        }
        if (vcareType.getDataSeq() != null) {
            int dataSeq = vcareType.getDataSeq().getSeq();
            ditMap.put(dataSeq, vcareType.getDataSeq());
        }

        //TODO add by kerryzhang.
        if (vcareType.getSn() != null) {
            int dataSeq = vcareType.getSn().getSeq();
            ditMap.put(dataSeq, vcareType.getSn());
        }

        Set<Integer> set = ditMap.keySet();
        new ArrayList<>(set).sort(Integer::compareTo);
        return ditMap;
    }

    private static Map<Integer, List<AFN>> initDownAFNs(VcarecityPD vcareType) {
        Map<Integer, List<AFN>> downAFNs = new ConcurrentHashMap<>(32);
        List<AFN> afnList = vcareType.getDataItem();
        List<AFN> afnLss = null;

        for (AFN afn : afnList) {
            if (afn.getDirection() == DataTypeConstant.CMD_DIR_DOWN) {
                Integer afnNo = afn.getAfn();
                /// afns.put(afnNo, afn);
                if (downAFNs.get(afnNo) == null) {
                    afnLss = new ArrayList<>();
                    downAFNs.put(afnNo, afnLss);
                }
                // update by kerryzhang
                if (afnLss == null) {
                    afnLss = new ArrayList<>();
                }
                afnLss.add(afn);
            }
        }
        return downAFNs;
    }

    private static Map<Integer, AFN> initUpAFNs(VcarecityPD vcareType) {
        Map<Integer, AFN> upAfns = new ConcurrentHashMap<>(32);
        List<AFN> afnList = vcareType.getDataItem();
        for (AFN afn : afnList) {
            if (afn.getDirection() == DataTypeConstant.CMD_DIR_UP) {
                upAfns.put(afn.getAfn(), afn);
            }
        }
        return upAfns;
    }

    private static Map<Integer, Map<Integer, DataElementType>> initDataElementMap(Map<Integer, AFN> upAfns) {
        Map<Integer, Map<Integer, DataElementType>> dataElementMap = new ConcurrentHashMap<>(32);
        for (Map.Entry<Integer, AFN> integerAFNEntry : upAfns.entrySet()) {
            AFN afn = integerAFNEntry.getValue();
            List<DataElementType> dataElemntTypeList = afn.getDataElement();

            Map<Integer, DataElementType> deMap = new ConcurrentHashMap<>();
            if (dataElemntTypeList != null) {
                for (DataElementType deType : dataElemntTypeList) {
                    deMap.put(deType.getDataCatagory(), deType);
                }
            }
            dataElementMap.put(afn.getAfn(), deMap);
        }
        return dataElementMap;
    }

}

