package com.vcarecity.xml.service;



import com.vcarecity.allcommon.context.MessageContext;

import com.vcarecity.common.service.IParserFrameService;
import com.vcarecity.common.service.NotifyEventService;
import org.jetbrains.annotations.Nullable;

/**
 * @author Kerry on 18/09/14
 */

public interface IXmlParserFrameService extends IParserFrameService<MessageContext> {

    /**
     * XML解析时,不用这个方法
     *
     * @param frameData 收到的原始数据
     * @return
     */
    @Override
    default MessageContext parserFrame(byte[] frameData) {
        parserFrameByXml(frameData, null);
        return null;
    }


    /**
     * XML解析时,用这个方法
     *
     * @param frameData
     * @param notifyEventService 回调接口
     */
    void parserFrameByXml(byte[] frameData, @Nullable NotifyEventService notifyEventService);

}
