package com.vcarecity.xml.service.impl;

import com.vcarecity.allcommon.exception.NoRequireKeyException;
import com.vcarecity.common.context.BaseJsonViewBean;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.service.IXmlConvertJsonService;
import com.vcarecity.xml.util.CheckUtil;
import com.vcarecity.xml.util.FepPackageUtil;
import com.vcarecity.xml.util.ProtocalUtil;
import com.vcarecity.xml.xml.ProtocolInstance;
import com.vcarecity.xml.xml.entity.AFN;
import com.vcarecity.xml.xml.entity.DItem;
import com.vcarecity.xml.xml.entity.VcarecityPD;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/09/14
 */

public class XmlConvertJsonServiceImpl implements IXmlConvertJsonService<BaseJsonViewBean> {

    @SuppressWarnings("AlibabaMethodTooLong")
    @Override
    public byte[] convertJson(BaseJsonViewBean msg) throws NoRequireKeyException {

        String deviceId = msg.getUnitNo().toUpperCase();

        List<BaseJsonViewBean.DataItemDTO> dataItems = msg.getDataItems();
        if (dataItems == null || dataItems.isEmpty()) {
            throw new NoRequireKeyException("dataItems");
        }
        Map<Integer, List<AFN>> afns = ProtocolInstance.get().getDownAFNs();
        List<AFN> dataItemList = afns.get(msg.getFunctionWord());
        if (dataItemList == null || dataItemList.isEmpty()) {
            return null;
        }
        AFN dataItem = null;
        if (dataItemList.size() == 1) {
            dataItem = dataItemList.get(0);
        } else {
            BaseJsonViewBean.DataItemDTO ditMap = dataItems.get(0);

            Map paraMap = ditMap.getData();
            if (paraMap.get(DataTypeConstant.STATUS) != null) {
                Object statusObj = paraMap.get(DataTypeConstant.STATUS);
                if (statusObj != null) {
                    int status = Integer.parseInt(statusObj.toString());
                    dataItem = getAFNWithStatus(status, dataItemList);
                }
            }
        }

        if (dataItem == null) {
            //dataItem is null
            return null;
        }
        VcarecityPD pd = ProtocolInstance.get().getVcareType();

        //包头
        ///String startSymbol = pd.getProtocalStartSymbol();
        int startSymbolLen = pd.getProtocalStartSymbolLen();
        // 包尾
        String endSymbol = pd.getProtocalEndSymbol();
        int endSymbolLen = pd.getProtocalEndSymbolLen();

        Map<String, String> headMap = new HashMap<>(8);


        int headLen = 0;
        int fromAddLen = 0;
        int toAddLen = 0;
        if (pd.getFAddress() != null) {
            fromAddLen = pd.getFAddress().getLen();
        }

        if (pd.getTAddress() != null) {
            toAddLen = pd.getTAddress().getLen();
            headMap.put(pd.getTAddress().getName(), deviceId);
        }
        headMap.put(pd.getFunction().getName(), dataItem.getAfn() + "");

        int snLen = 0;

        int funLen = 0;
        if (pd.getFunction() != null) {
            funLen = pd.getFunction().getLen();
        }
        int dataLen = pd.getDataLen().getLen();

        headLen = fromAddLen + toAddLen + funLen + snLen + dataLen;

        Map dtiMap = new LinkedHashMap();

        for (BaseJsonViewBean.DataItemDTO item : dataItems) {
            String dti = String.valueOf(item.getId());
            dtiMap.put(dti, item.getData());
        }

//        for (Object item : dataItems) {
//            Map map = (Map) item;
//            String dti = (String) map.get("id");
//            Map paramMap = (Map) map.get(DataTypeConstant.PARAMS);
//            dtiMap.put(dti, paramMap);
//        }

        Map<String, String> valueMap = new HashMap<>(2);
        if (msg.getSn() != null) {
            valueMap.put(DataTypeConstant.SN, String.valueOf(msg.getSn()));
        }
        if (msg.getEquipmentNo() != null) {
            valueMap.put(DataTypeConstant.MP, String.valueOf(msg.getEquipmentNo()));
        }

        byte[] bodyByte = new FepPackageUtil().encode(dtiMap, valueMap, dataItem);

        if (bodyByte != null && bodyByte.length > 0) {
            dataLen = bodyByte.length;
            headMap.put(pd.getDataLen().getName(), String.valueOf(dataLen));
        }

        int pos = 0;
        byte[] headByte = new byte[headLen];


        Map<Integer, DItem> ditMap = ProtocolInstance.get().getDitMap();
        for (Map.Entry<Integer, DItem> entry : ditMap.entrySet()) {
            DItem item = entry.getValue();
            String itemName = item.getName();
            int len = item.getLen();
            int dt = item.getType();
            String fieldVal = headMap.get(itemName);
            if (fieldVal != null) {
                switch (dt) {
                    case DataTypeConstant.STR:
                        System.arraycopy(fieldVal.getBytes(), 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.HEX:
                        //System.arraycopy(new ProtocalUtil().hexStringToByte(fieldVal), 0, headByte, pos, len);
                        System.arraycopy(HexUtil.hexToByteArray(fieldVal), 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.WORD:
                        byte[] wordData = new byte[len];
                        ProtocalUtil.convert2Byte(wordData, 0, Short.valueOf(fieldVal));
                        System.arraycopy(wordData, 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.DWORD:
                        //add by kerry
                        byte[] dWordData = new byte[len];
                        ProtocalUtil.convert2Byte(dWordData, 0, Short.valueOf(fieldVal));
                        System.arraycopy(dWordData, 0, headByte, pos, len);
                        break;
                    default:
                        break;
                }
                pos += len;
            }
        }
        byte[] bodyFrame = FepPackageUtil.getBodyByte(pd, headByte, bodyByte);
        DItem dataCheck = pd.getDataCheck();
        // 添加校验码
        if (dataCheck != null) {
            int subLen = bodyFrame.length - startSymbolLen;
            byte[] subFrame = new byte[subLen];
            System.arraycopy(bodyFrame, startSymbolLen, subFrame, 0, subLen);
            //取出校验算法
            int crcValMode = dataCheck.getVal();
            int checkCodeLen = dataCheck.getLen();

            byte[] checkByte = CheckUtil.checkCrcCode(crcValMode, checkCodeLen, subFrame);

            byte[] rspByte = new byte[bodyFrame.length + checkCodeLen];
            System.arraycopy(bodyFrame, 0, rspByte, 0, bodyFrame.length);
            System.arraycopy(checkByte, 0, rspByte, bodyFrame.length, checkByte.length);

            bodyFrame = new byte[rspByte.length];
            // 设置返回报文
            System.arraycopy(rspByte, 0, bodyFrame, 0, rspByte.length);
        }
        //如果有,添加尾标识
        if (endSymbolLen > 0) {
            byte[] tempBody = new byte[bodyFrame.length];
            System.arraycopy(bodyFrame, 0, tempBody, 0, bodyFrame.length);
            bodyFrame = new byte[bodyFrame.length + endSymbolLen];
            System.arraycopy(tempBody, 0, bodyFrame, 0, bodyFrame.length);
            System.arraycopy(endSymbol.getBytes(), 0, bodyFrame, tempBody.length, endSymbolLen);
        }

        if (bodyByte != null && bodyByte.length > 0) {
            dataLen = bodyByte.length;
            headMap.put(pd.getDataLen().getName(), dataLen + "");
        }
        return bodyFrame;
    }


    private AFN getAFNWithStatus(int status, List<AFN> dataItemList) {

        for (AFN dItem : dataItemList) {
            int itemStarts = dItem.getStatus();
            if (itemStarts == status) {
                return dItem;
            }
        }
        return null;
    }

}
