package com.vcarecity.xml.service.impl;

import com.vcarecity.common.service.NotifyEventService;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.json.ByteToJackson;
import com.vcarecity.xml.json.ByteToJsonObject;
import com.vcarecity.xml.config.XmlMqConfig;
import com.vcarecity.xml.config.XmlAboutConfig;
import com.vcarecity.xml.service.IXmlParserFrameService;
import com.vcarecity.xml.util.*;
import com.vcarecity.xml.xml.ProtocolInstance;
import com.vcarecity.xml.xml.bean.FrameDetailBean;
import com.vcarecity.xml.xml.entity.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Kerry on 18/09/14
 */

public class XmlParserFrameServiceImpl implements IXmlParserFrameService {

    private static Logger logger = LoggerFactory.getLogger(XmlParserFrameServiceImpl.class);


    private Integer funWord;

    /**
     * 收到的数据
     */
    protected byte[] receiveData;
    /**
     * 设备地址
     */
    protected String deviceId;
    /**
     * 回复数据
     */
    protected byte[] responseData;


    @SuppressWarnings("AlibabaMethodTooLong")
    @Override
    public void parserFrameByXml(byte[] data, NotifyEventService notifyEventService) {

        this.receiveData = data;

        VcarecityPD pd = ProtocolInstance.get().getVcareType();
        String start = pd.getProtocalStartSymbol();
        int startLen = pd.getProtocalStartSymbolLen();

        byte[] headMask = new byte[startLen];


        System.arraycopy(data, 0, headMask, 0, startLen);

        if (!Arrays.equals(headMask, HexUtil.hexToByteArray(start))) {
            logger.debug("frame mask not equals 7e7e7e,data=[{}]", HexUtil.byteArrayToHex(data));
            return;
        }
        //XML协议 , 没有计算的
        Map<Integer, DItem> itemMap = ProtocolInstance.get().getDitMap();
        Set<Map.Entry<Integer, DItem>> set = itemMap.entrySet();
        Map<Integer, byte[]> dItemMap = new HashMap<>();      //放已经计算的
        //<DataSeq/> 是数据占位符
        int position = startLen;
        for (Map.Entry<Integer, DItem> entry : set) {
            Integer key = entry.getKey();
            DItem ditem = entry.getValue();
            int len = ditem.getLen();
            byte[] content = new byte[len];
            System.arraycopy(data, position, content, 0, len);
            position += len;
            dItemMap.put(key, content);
        }


        Map<Integer, FrameDetailBean> msgHeadMap = new ConcurrentHashMap<>(8);
//        Map<String, FrameDetailBean> headMap = new HashMap<>();
        Map<String, FrameDetailBean> headMap = new ConcurrentHashMap<>();


        //数据
        position = startLen;

        int fAddLen = 0;
        if (pd.getFAddress() != null) {
            int fAddSeq = pd.getFAddress().getSeq();   //排序
            fAddLen = pd.getFAddress().getLen();   //长度
            byte[] fAddBytes = dItemMap.get(fAddSeq);   //内容
            FrameDetailBean fdb = new FrameDetailBean(fAddSeq, position, fAddLen, fAddBytes);
            position += fAddLen;
            headMap.put(pd.getFAddress().getName(), fdb);
        }
        int tAddLen = 0;
        if (pd.getTAddress() != null) {
            int tAddSeq = pd.getTAddress().getSeq();   //排序
            tAddLen = pd.getTAddress().getLen();   //长度
            byte[] tAddBytes = dItemMap.get(tAddSeq);   //内容
            FrameDetailBean fdb = new FrameDetailBean(tAddSeq, position, tAddLen, tAddBytes);
            position += tAddLen;
            headMap.put(pd.getTAddress().getName(), fdb);

            this.deviceId = HexUtil.byteArrayToHex(tAddBytes);
        }

        int funcLen = 0;
        if (pd.getFunction() != null) {
            int funcSeq = pd.getFunction().getSeq();   //排序
            funcLen = pd.getFunction().getLen();   //长度
            byte[] funCBytes = dItemMap.get(funcSeq);   //内容
            FrameDetailBean fdb = new FrameDetailBean(funcSeq, position, funcLen, funCBytes);
            position += funcLen;
            headMap.put(pd.getFunction().getName(), fdb);

            funWord = HexUtil.byteArrayToInt(funCBytes);
        }

        int snLen = 0;
        if (pd.getSn() != null) {
            int snSeq = pd.getSn().getSeq();   //排序
            snLen = pd.getSn().getLen();   //长度
            byte[] snBytes = dItemMap.get(snSeq);   //内容
            FrameDetailBean fdb = new FrameDetailBean(snSeq, position, snLen, snBytes);
            position += snLen;
            headMap.put(pd.getSn().getName(), fdb);
        }

        int dataLenLen = 0;     //数据长度所占的长度
        int msgBodyLen = 0;     //消息体长度
        if (pd.getDataLen() != null) {
            int dataLenSeq = pd.getDataLen().getSeq();   //排序
            dataLenLen = pd.getDataLen().getLen();   //排序
            byte[] dataLenBytes = dItemMap.get(dataLenSeq);   //内容
            msgBodyLen = Integer.parseInt(HexUtil.byteArrayToHex(dataLenBytes), 16);

            //帧中定义的数据长度
            FrameDetailBean dataLenDetailbean = new FrameDetailBean(dataLenSeq, position, dataLenLen, dataLenBytes);
            position += dataLenLen;

            headMap.put(pd.getDataLen().getName(), dataLenDetailbean);
        }


        byte[] dataBodyBytes = new byte[msgBodyLen];   //消息体的BYTE[]

        //原来XML文件只是定义占位的.现在这里要用真正数据长度
        if (pd.getDataSeq() != null) {
            int dataSeqSeq = pd.getDataSeq().getSeq();   //排序
            int startPos = ProtocolInstance.get().getFrameIndex(dataSeqSeq) + startLen;//pd.getDataSeq().getLen();   //长度

            //检验帧中定义的长度,与帧上的实际数据长度是否相等
            int dataCheckLength = 0;
            if (pd.getDataCheck() != null) {
                dataCheckLength = pd.getDataCheck().getLen();
            }
            if (data.length != (startPos + msgBodyLen + dataCheckLength)) {
                logger.debug("frame error,please check frame length and actual length,data=[{}]", HexUtil.byteArrayToHex(data));
                return;
            }
            System.arraycopy(data, position, dataBodyBytes, 0, msgBodyLen);

            //Message Body
//            FrameDetailBean fdb = new FrameDetailBean(dataSeqSeq, startPos, msgBodyLen, dataBodyBytes);
//            headMap.put(pd.getDataSeq().getName(), fdb);
            position += msgBodyLen;
        }

        if (pd.getDataCheck() != null) {
            DItem dataCheckItem = pd.getDataCheck();
            int dataCheckSeq = dataCheckItem.getSeq();
            int dataCheckLen = dataCheckItem.getLen();

            byte[] dataCheckBytes = new byte[dataCheckLen];
            System.arraycopy(data, position, dataCheckBytes, 0, dataCheckLen);

            position += dataCheckLen;

            //查看计算的CRC和上传CRC是否正确
            byte[] noHead = new byte[fAddLen + tAddLen + funcLen + dataLenLen + snLen + msgBodyLen];       //消息头&消息体
            System.arraycopy(data, startLen, noHead, 0, noHead.length);

          /*  byte[] calcCheckCode = new byte[dataCheckLen];
            switch (dataCheckItem.getVal()) {
                case DataTypeConstant.CRC_ADD:
                    int crc = CrcUtil.validate(noHead);
                    calcCheckCode[0] = (byte) crc;
                    break;
                case DataTypeConstant.CRC_ADD_16:
                    int crc16 = CrcUtil.crc16(noHead);
                    String checkHex = HexUtil.strFrontWithZero(Integer.toHexString(crc16), dataCheckLen * 2);
                    calcCheckCode = HexUtil.hexToBytes(checkHex);
                    break;
                default:
                    break;
            }*/
            byte[] calcCheckCode = CheckUtil.checkCrcCode(dataCheckItem.getVal(), dataCheckLen, noHead);

            if (!Arrays.equals(dataCheckBytes, calcCheckCode)) {
//                System.out.println("crc error!"
//                        + " .receive crc = " + HexUtil.apacheBytesToHex(dataCheckBytes)
//                        + ". calc crc = " + HexUtil.apacheBytesToHex(calcCheckCode)
//                        + ". calc body = " + HexUtil.apacheBytesToHex(noHead)
//                        + ". source = " + HexUtil.apacheBytesToHex(data));

                logger.debug("CRC ERROR,Calc={},data=[{}]", calcCheckCode, HexUtil.byteArrayToHex(data));

                return;
            }
        }

        FrameDetailBean function = headMap.get(pd.getFunction().getName());
        if (function == null) {
//            System.out.println("Function Code = " + pd.getFunction().getName() + " is not exits!!!");
//            MLog.warn(LogType.LOG_REC, "Function Code = " + pd.getFunction().getName() + " is not exits!!!");

            logger.debug("FunctionCode Not Exist,{}", HexUtil.byteArrayToHex(data));
            return;
        }
        int funCodeTen = HexUtil.byteArrayToInt(function.getData());

        Map<Integer, AFN> upAFNs = ProtocolInstance.get().getUpAfns();   //取到当前功能码的所有指令集合

        AFN dataItem = upAFNs.get(funCodeTen);                   //取出当前功能码对应的指令 <dataItem>...</dataItem>

        if (dataItem == null) {
//            System.out.println("There is no such up command. FunCode(10)=["
//                    + funCodeTen + "].FunCode(16)=[" + Integer.toHexString(funCodeTen)
//                    + "]. source=" + HexUtil.apacheBytesToHex(data));
//            MLog.warn(LogType.LOG_REC, "There is no such up command. FunCode(10)=["
//                    + funCodeTen + "].FunCode(16)=[" + Integer.toHexString(funCodeTen)
//                    + "]. source=" + HexUtil.apacheBytesToHex(data));

            return;
        }

        /*
        <dataItem>.
            <DataElement>...</DataElement>
            <DataElement>...</DataElement>
            <DataElement>...</DataElement>
            <data>...</data>
            <data>...</data>
         </dataItem>
         */

        List<DataType2> dataList = dataItem.getData();
        List<DataElementType> dataElementList = dataItem.getDataElement();
        List<List<Map>> dtiVals = new ArrayList<>();


        Map<String, String> fieldMap = new HashMap<>(16);

        position = 0;           //reset position
        // 下面的position的作用是开始的position

        //功能码&消息流水
        if (!dataList.isEmpty()) {
            for (DataType2 dataType2 : dataList) {
                if (dataType2 == null) {
                    continue;
                }

                DataEntity dataEntity = new DataEntity();
                dataEntity.setStartPos(position);
                dataEntity.setDataType2(dataType2);

                dataEntity.setName(dataType2.getElementName());
                getDataType2Data(dataBodyBytes, dataEntity);
                position = dataEntity.getStartPos();
                fieldMap.put(dataEntity.getName(), dataEntity.getVal());    //<data/>

                // 如果数据长度标示为-1,截取到结尾跳出
                if (dataEntity.getDataType2().getElementLen() == -1) {
                    break;
                }
            }
        }


        Map<String, DataElementType> dtiCodeMap = new HashMap<>();
        String dti;

        if (!dataElementList.isEmpty()) {

            FacadeFrame<String, String> frameObj = new FacadeFrame<>();

            if (dataElementList.size() > 1) {

                //一个功能码对应有多个数据编码且帧中含有数据编码的情况.多个<DataElement/>
                for (DataElementType dataElementType : dataElementList) {
                    if (dataElementType == null) {
                        continue;
                    }
                    int category = dataElementType.getDataCatagory();
                    dtiCodeMap.put(category + "", dataElementType);
                }

                //全部否认帧，接收下发多参数指令后，如果某个数据参数出错，下发失败，终端返回否认帧,
                //像这样的.只有功能字,没有数据的情况.0502. 7e7e7e4442832e833ca000050000000502b6
                if (dataBodyBytes.length <= position + 2) {

                    List<Map> dtis = new ArrayList<>();
                    Map dataElementMap = new HashMap<>();

                    dataElementMap.put(DataTypeConstant.RET, "1");
                    Map dataCatagoryMap = new HashMap<>();

                    dataCatagoryMap.put(DataTypeConstant.Data, dataElementMap);
                    dataCatagoryMap.put(DataTypeConstant.ID, "-1");
                    dtis.add(dataCatagoryMap);
                    dtiVals.add(dtis);
                } else {
                    // 如果数据阈包含多个数据单元，递归解析之，直到帧尾。
                    while (dataBodyBytes.length > position) {
                        //多参数时，帧中必须以数据编码区分相应的数据单元
                        byte[] diCode = new byte[2];  //取出类似 0502 这样的功能字.这里写死了
                        System.arraycopy(dataBodyBytes, position, diCode, 0, 2);
                        dti = CurrentHexUtil.getShort(diCode) + "";
                        DataElementType dataElementType = dtiCodeMap.get(dti);
                        //如果后续字节没有匹配的数据标示单元，退出。
                        if (dataElementType == null) {
                            break;
                        }
                        //解析<d1/>

                        frameObj.setBodyData(dataBodyBytes);
                        frameObj.setDti(dti);
                        frameObj.setDe(dataElementType);
                        frameObj.setPos(position);
                        frameObj.setFiledMap(fieldMap);
                        List<Map> dtis = parsePacket(frameObj);
                        dtiVals.add(dtis);
                        position = frameObj.getPos();
                    }
                }
            } else {
                //一个功能码下只有一个<DataElement/>
                DataElementType dataElementType = dataElementList.get(0);
                dti = String.valueOf(dataElementType.getDataCatagory());
                frameObj.setBodyData(dataBodyBytes);
                frameObj.setDti(dti);
                frameObj.setDe(dataElementType);
                frameObj.setPos(position);
                frameObj.setFiledMap(fieldMap);
                List<Map> dtis = parsePacket(frameObj);
                dtiVals.add(dtis);
            }
        }

        //如果需要向平台发送报文解析信息，封装成json格式的数据包发送至平台接口,MQ开启才有必要生成JSON
        if (XmlMqConfig.isEnable() && dataItem.getAck() == 1) {
            generateJsonData(notifyEventService, dataItem.getMq(), headMap, dtiVals, funCodeTen, fieldMap);
        }

        // 如果需要回复
        if (dataItem.getRespAfnId() != 0) {
            responseHandle(headMap, fieldMap, dataItem, dtiVals);
        }
    }


    private void generateJsonData(NotifyEventService notifyEventService, int activeMqQuqueType, Map<String, FrameDetailBean> headMap, List<List<Map>> dtiVals, int funCodeTen, Map<String, String> fieldMap) {
        //sendToMq to mq
        if (notifyEventService != null) {
            Object obj;
            if (XmlAboutConfig.getJsonMode() == 0) {
                obj = new ByteToJsonObject().createJsonObject(headMap, dtiVals, funCodeTen, fieldMap);
            } else {
                obj = new ByteToJackson().createJsonObject(headMap, dtiVals, funCodeTen, fieldMap);
            }
            notifyEventService.eventNotification(activeMqQuqueType, obj);
        }
    }

    /**
     * 回复
     *
     * @param headMap
     * @param headMap
     * @param fieldMap
     * @param dataItem
     * @param dtiVals
     */
    private void responseHandle(Map<String, FrameDetailBean> headMap, Map<String, String> fieldMap, AFN dataItem, List<List<Map>> dtiVals) {

        VcarecityPD pd = ProtocolInstance.get().getVcareType();

        Map<Integer, List<AFN>> afns = ProtocolInstance.get().getDownAFNs();


        int respId = -1;
        if (dataItem.getType() == DataTypeConstant.ABS) {
            // 按高位取反
            respId = 1;
        } else if (dataItem.getType() == DataTypeConstant.RESP) {
            // 按配置返回命令
            respId = dataItem.getRespAfnId();
        }

        // 开始字符+原地址+目的地址+命令字+流水号+数据长度
        // int respId = dataItem.getRespAfnId();

        List<AFN> resDataItemList = afns.get(respId);

        if (resDataItemList == null) {
//            System.out.println("回复." + respId);
//            MLog.warn(LogType.LOG_REC, "回复.无此指令编码,cmd id=" + respId);

            logger.debug("ResponseCmdNotFound,cmd={}", respId);

            return;
        }
        DItem function = pd.getFunction();
        if (function == null) {
//            System.out.println("功能码不存在!");
//            MLog.warn(LogType.LOG_REC, "回复.功能码不存在");
            logger.debug("ResponseKeyFieldNotFound,cmd={}", pd.getFunction());
            return;
        }

        FrameDetailBean functionBean = headMap.get(function.getName());

//        byte[] funcodeBytes = new byte[functionBean.getDataLen()];
        byte[] funcodeBytes = HexUtil.intToByteArray(dataItem.getRespAfnId(), functionBean.getDataLen());
        functionBean.setData(funcodeBytes);
        headMap.put(function.getName(), functionBean);

        AFN resDataItem = resDataItemList.get(0);

        //消息头的长度
        int headLen = 0;// FrameBeanUtil.getMessageHeaderLen(fb);
        for (Map.Entry<String, FrameDetailBean> entry : headMap.entrySet()) {
            headLen += entry.getValue().getDataLen();
        }

        byte[] headByte = new byte[headLen];
        int pos = 0;


        //数据长度取决于 消息体的长度

        // 第一步，封装数据域的内容.这里是指 数据域 带重复的情况.这里只要第一个就可以了. 多个 data
        Map<Object, Object> dtiMap = new HashMap<>();
        if (dtiVals != null && dtiVals.size() > 0) {
            List tempItemList = dtiVals.get(0);
            for (Object dti1 : tempItemList) {
                Map map = (Map) dti1;
                String dti = (String) map.get("id");
                Map paramMap = (Map) map.get(DataTypeConstant.PARAMS);
                dtiMap.put(dti, paramMap);
            }
        }

        int dataLen = 0;    //数据长度
        byte[] bodyByte = new FepPackageUtil().encode(dtiMap, fieldMap, resDataItem);   //得到消息体报文
        if (bodyByte != null && bodyByte.length > 0) {
            dataLen = bodyByte.length;  //得到数据长度
            FrameDetailBean dataLenBean = headMap.get(pd.getDataLen().getName());
            byte[] lenOrig = HexUtil.hexToByteArray(Integer.toHexString(dataLen));
            byte[] bLen = new byte[dataLenBean.getDataLen()];
            System.arraycopy(lenOrig, 0, bLen, bLen.length - lenOrig.length, lenOrig.length);
            dataLenBean.setData(bLen);
            headMap.put(pd.getDataLen().getName(), dataLenBean);
        }

        Map<Integer, DItem> itemMap = ProtocolInstance.get().getDitMap();
        Set<Map.Entry<Integer, DItem>> resSet = itemMap.entrySet();

        for (Map.Entry<Integer, DItem> item : resSet) {
            DItem ditem = item.getValue();
            int dataType = ditem.getType();
            // 根据字节类型获取报文
            int len = ditem.getLen();
            FrameDetailBean fieldVal = headMap.get(ditem.getName());

            // 根据帧的序号，获取帧的字节码
            if (fieldVal != null) {
                switch (dataType) {
                    case DataTypeConstant.STR:
//                        System.arraycopy(fieldVal.getBytes(), 0, headByte, pos, len);
                        System.arraycopy(fieldVal.getData(), 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.HEX:
//                        System.arraycopy(util.hexStringToByte(fieldVal), 0, headByte, pos, len);
                        System.arraycopy(fieldVal.getData(), 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.WORD:
                        byte[] wordData = new byte[len];
//                        ProtocalUtil.convert2Byte(wordData, 0, Short.valueOf(fieldVal));
//                        System.arraycopy(wordData, 0, headByte, pos, len);
                        System.arraycopy(fieldVal.getData(), 0, headByte, pos, len);
                        break;
                    case DataTypeConstant.TIME:
                        TimeTag timeTag = new TimeTag(System.currentTimeMillis());
                        byte[] andTime = timeTag.toMiddleBcd();
                        System.arraycopy(andTime, 0, headByte, pos, len);
                    default:
                        break;
                } //end switch
                pos += len;
            }         //end if
        } //end for


//        System.out.println("headByte=" + Hex.encodeHexString(headByte));

        // 第三步、封装包头和包尾
        byte[] bodyFrame = FepPackageUtil.getBodyByte(pd, headByte, bodyByte);

//        System.out.println("bodyFrame=" + Hex.encodeHexString(bodyFrame));

        DItem dataCheckItem = pd.getDataCheck();

        //回复

        //添加校验码
        if (dataCheckItem != null) {
            int crcStartPos = pd.getProtocalStartSymbolLen();
            int calcBodyLen = bodyFrame.length - crcStartPos;   //标识头不算入CRC
            int checkCodeLen = dataCheckItem.getLen();          //CRC所占长度
            byte[] checkCodeByteArr = new byte[calcBodyLen];    //计算BYTE[]
            System.arraycopy(bodyFrame, crcStartPos, checkCodeByteArr, 0, calcBodyLen);
            byte[] replyByte = new byte[bodyFrame.length + checkCodeLen];
            System.arraycopy(bodyFrame, 0, replyByte, 0, bodyFrame.length);
            byte[] crcCodeByte = CheckUtil.checkCrcCode(dataCheckItem.getVal(), checkCodeLen, checkCodeByteArr);
            System.arraycopy(crcCodeByte, 0, replyByte, bodyFrame.length, dataCheckItem.getLen());

            bodyFrame = new byte[replyByte.length];
            // 设置返回报文
            System.arraycopy(replyByte, 0, bodyFrame, 0, replyByte.length);
        }


        int endSymbolLen = pd.getProtocalEndSymbolLen();
        String endSymbol = pd.getProtocalEndSymbol();
        if (endSymbol != null && endSymbol.length() > 0) {
            byte[] tempBody = new byte[bodyFrame.length];
            System.arraycopy(bodyFrame, 0, tempBody, 0, bodyFrame.length);
            bodyFrame = new byte[bodyFrame.length + endSymbolLen];
            System.arraycopy(tempBody, 0, bodyFrame, 0, bodyFrame.length);
            System.arraycopy(endSymbol.getBytes(), 0, bodyFrame, tempBody.length, endSymbolLen);
        }

        //System.out.println("回复报文:" + Hex.encodeHexString(bodyFrame));
        responseData = bodyFrame;
    }

    private static void getDataType2Data(byte[] bodyData, DataEntity dataEntity) {

        /*
            <ElementSequence>3</ElementSequence>
            <ElementLen>2</ElementLen>
            <ElementName>char</ElementName>
            <ElementValue>1</ElementValue>
            <ElementType>4</ElementType>
            <ElementFactor>1</ElementFactor>
            <ElementPrecision>1</ElementPrecision>
         */
        DataType2 dataType2 = dataEntity.getDataType2();
        int elementLen = dataType2.getElementLen();
        int elementType = dataType2.getElementType();
        String factor = dataType2.getElementFactor();
        int pos = dataEntity.getStartPos();

        String dataStr = null;
        byte[] data;
        // <ElementLen/> 数据元素长度为-1时，截取当前位置到最后
        // 否则，截取elementLen个字节
        if (elementLen <= -1) {
            elementLen = bodyData.length - pos;
            data = new byte[elementLen];
            System.arraycopy(bodyData, pos, data, 0, bodyData.length - pos);
        } else {
            data = new byte[elementLen];
            System.arraycopy(bodyData, pos, data, 0, elementLen);
        }
        // 根据数据类型解析所截取字节
        switch (elementType) {
            case DataTypeConstant.STR:
                // 字符串型
                dataStr = new String(data);
                break;
            case DataTypeConstant.HEX:
                // 16进制
                ///dataStr = ProtocalUtil.bytesToHexString(data);
                ///dataStr = Hex.encodeHexString(data).toUpperCase();    //使用Apache Codec 优化转换
                //使用Apache Codec 优化转换
                dataStr = HexUtil.byteArrayToHex(data);
                break;
            case DataTypeConstant.WORD:
                // 双字节
                dataStr = "" + ProtocalUtil.convertByte2Int(data);
                if (factor != null && !"1".equals(factor)) {
                    //进制转换 小数处理比较麻烦.所以乘上一个1000变成整数
                    dataStr = new BigDecimal(dataStr).multiply(new BigDecimal(factor)).doubleValue() + "";
                }
                break;
            case DataTypeConstant.DWORD:
                // 四字节
                dataStr = "" + ProtocalUtil.convertByte2Int(data);
                if (factor != null && !"1".equals(factor)) {
                    //进制转换 小数处理比较麻烦.所以乘上一个1000变成整数
                    dataStr = new BigDecimal(dataStr).multiply(new BigDecimal(factor)).doubleValue() + "";
                }
                break;
            default:
                break;
        }
        pos += elementLen;
        dataEntity.setVal(dataStr);
        dataEntity.setStartPos(pos);
    }


    private List<Map> parsePacket(FacadeFrame frameObj) {

        Map filedMap = frameObj.getFiledMap();
        byte[] bodyData = frameObj.getBodyData();
        String dti = frameObj.getDti();
        DataElementType de = frameObj.getDe();
        int position = frameObj.getPos();
        int elementNum = de.getNum();

        List<Map> dtis = new ArrayList<>();
        List<DataType> dataTypes = de.getData();
        if (elementNum != 1) {
            elementNum = bodyData[position];
            position += 1;
        }

        DataType dataType = dataTypes.get(0);

        List<DataType2> dataList = dataType.getD1();

        List<DataType2> dt2List = new ArrayList<>();

        dt2List.addAll(dataList);
        for (int k = 0; k < elementNum; k++) {
            Map<String, Object> dataElementMap = new HashMap<>();
            String preName = null;
            String preCnt = null;

            for (int i = 0; i < dt2List.size(); ) {
                DataType2 dt2 = dt2List.get(i);
                DataEntity dataEntity = new DataEntity();
                dataEntity.setName(dt2.getElementName());
                dataEntity.setStartPos(position);
                if (DataTypeConstant.CNT.equals(preName)) {
                    dt2.setElementLen(Integer.valueOf(preCnt));
                }
                dataEntity.setDataType2(dt2);
                getDataType2Data(bodyData, dataEntity);
                if (DataTypeConstant.dataCnt.equals(dt2.getElementName())) {
                    List<DataType2> removeList = new ArrayList<>();
                    for (int index = 0; index <= i; index++) {
                        removeList.add(dt2List.get(index));
                    }
                    dt2List.removeAll(removeList);
                    i = 0;
                    elementNum = Integer.valueOf(dataEntity.getVal().trim());
                    position = dataEntity.getStartPos();
                    continue;
                }
                position = dataEntity.getStartPos();
                filedMap.put(dataEntity.getName(), dataEntity.getVal());
                dataElementMap.put(dataEntity.getName(), dataEntity.getVal().trim());
                preName = dataEntity.getName();
                preCnt = dataEntity.getVal();
                i++;
            }
            if (dataElementMap.size() > 0 && dataElementMap.get(DataTypeConstant.RET) == null) {
                dataElementMap.put(DataTypeConstant.RET, "0");
            }
            Map<String, Object> dataCatagoryMap = new HashMap<>();
            if (filedMap.get(DataTypeConstant.dateTime) != null) {
                dataElementMap.put(DataTypeConstant.dateTime, filedMap.get(DataTypeConstant.dateTime));
            }
            dataCatagoryMap.put(DataTypeConstant.Data, dataElementMap);
            dataCatagoryMap.put(DataTypeConstant.ID, dti);
            dtis.add(dataCatagoryMap);
        }
        frameObj.setPos(position);
        return dtis;
    }

    static class FacadeFrame<T1, T2> {

        private Map<T1, T2> filedMap;

        private byte[] bodyData; //报文

        private int pos; //字节游标

        private DataElementType de; //数据元素单元

        private String dti; //数据标示单元码

        private List metas; //分发数据

        public List getMetas() {
            return metas;
        }

        public void setMetas(List metas) {
            this.metas = metas;
        }

        public int getPos() {
            return pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public Map<T1, T2> getFiledMap() {
            return filedMap;
        }

        public void setFiledMap(Map<T1, T2> filedMap) {
            this.filedMap = filedMap;
        }

        public byte[] getBodyData() {
            return bodyData;
        }

        public void setBodyData(byte[] bodyData) {
            this.bodyData = bodyData;
        }

        public DataElementType getDe() {
            return de;
        }

        public void setDe(DataElementType de) {
            this.de = de;
        }

        public String getDti() {
            return dti;
        }

        public void setDti(String dti) {
            this.dti = dti;
        }

    }


    public byte[] getReceiveData() {
        return receiveData;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }


    public byte[] getResponseData() {
        return responseData;
    }

    public void setResponseData(byte[] responseData) {
        this.responseData = responseData;
    }


    public Integer getFunWord() {
        return funWord;
    }

    public void setFunWord(Integer funWord) {
        this.funWord = funWord;
    }

}
