package com.vcarecity.xml.util;

import com.vcarecity.common.util.CrcUtil;
import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.xml.constant.DataTypeConstant;


/**
 * @author KerryZhang
 */
public class CheckUtil {


    /**
     * @param checkCodeVal    CRC类型
     * @param dataCheckLen    CRC所占长度
     * @param noHeadByteArray 要检验的BYTE[]
     * @return
     */
    public static byte[] checkCrcCode(Integer checkCodeVal, int dataCheckLen, byte[] noHeadByteArray) {
        byte[] calcCheckCode = new byte[dataCheckLen];
        switch (checkCodeVal) {
            case DataTypeConstant.CRC_ADD:
                int crc = CrcUtil.validate(noHeadByteArray);
                calcCheckCode[0] = (byte) crc;
                break;
            case DataTypeConstant.CRC_ADD_16:
                int crc16 = CrcUtil.crc16(noHeadByteArray);
                String checkHex = strFrontWithZero(Integer.toHexString(crc16), dataCheckLen * 2);
                calcCheckCode = HexUtil.hexToByteArray(checkHex);
                break;
            default:
                break;
        }
        return calcCheckCode;
    }


    private static String strFrontWithZero(String source, int len) {
        int delta = Math.abs(len - source.length());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < delta; i++) {
            sb.append("0");
        }
        return sb.toString() + source;
    }

}
