package com.vcarecity.xml.util;

/**
 * author Kerry
 * date 2017/9/25
 * desp null
 */


import com.vcarecity.allcommon.util.HexUtil;
import com.vcarecity.common.util.CrcUtil;
import com.vcarecity.xml.constant.DataTypeConstant;
import com.vcarecity.xml.xml.entity.*;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class FepPackageUtil {

    public static final String PKG_CHAR_ENCODING = "ascii";

    public static final byte START_FLAG = 0x5B;

    public static final byte END_FLAG = 0x5D;

    private static final byte flagB = 0x5B;

    private static final byte flagC = 0x5C;

    private static final byte flagD = 0x5D;

    public static final int DATA_TYPE_STR = 1;// 字符串类型

    public static final int DATA_TYPE_DEC = 2;// 数字类型

    public static final int DATA_TYPE_BCD = 3;// BCD码

    public static byte[] oldEscape(byte[] data) {
        List<Integer> positions = new ArrayList<Integer>();
        for (int i = 12; i < data.length - 1; i++) {
            if (data[i] == flagB || data[i] == flagC || data[i] == flagD) {
                positions.add(i);
            }
        }

        if (positions.size() == 0) {
            return data;
        }

        byte[] copy = new byte[data.length + positions.size()];
        int srcPos = 0;
        int tarPos = 0;
        int copyLength;
        for (int i = 0; i < positions.size(); i++) {
            int espos = positions.get(i);
            copyLength = espos - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);

            srcPos = espos + 1;
            tarPos += copyLength;
            copy[tarPos] = 0x5C;
            copy[tarPos + 1] = (byte) (0x50 ^ data[espos]);
            tarPos += 2;
        }

        if (srcPos < data.length) {
            copyLength = data.length - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);
        }

        if (data.length > 12) {
            byte len = data[12];
            copy[12] = (byte) (len + positions.size());
        }

        return copy;

    }

    public static byte[] escape(byte[] data) {
        List<Integer> positions = new ArrayList<Integer>();
        for (int i = 1; i < data.length - 1; i++) {
            if (data[i] == flagB || data[i] == flagC || data[i] == flagD) {
                positions.add(i);
            }
        }

        if (positions.size() == 0) {
            return data;
        }

        byte[] copy = new byte[data.length + positions.size()];
        int srcPos = 0;
        int tarPos = 0;
        int copyLength;
        for (int i = 0; i < positions.size(); i++) {
            int espos = positions.get(i);
            copyLength = espos - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);

            srcPos = espos + 1;
            tarPos += copyLength;
            copy[tarPos] = 0x5C;
            copy[tarPos + 1] = (byte) (0x50 ^ data[espos]);
            tarPos += 2;
        }

        if (srcPos < data.length) {
            copyLength = data.length - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);
        }

        return copy;
    }

    private static boolean isEscapeCode(byte c) {
        return (c == 0xB || c == 0xC || c == 0xD);
    }

    public static byte[] unescape(byte[] data) {
        List<Integer> positions = new ArrayList<Integer>();
        for (int i = 1; i < data.length - 1; i++) {
            if (data[i] == flagC && isEscapeCode(data[i + 1])) {
                positions.add(i);
            }
        }

        if (positions.size() == 0) {
            return data;
        }

        byte[] copy = new byte[data.length - positions.size()];

        int srcPos = 0;
        int tarPos = 0;
        int copyLength;
        for (int i = 0; i < positions.size(); i++) {
            int uespos = positions.get(i);
            copyLength = uespos - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);

            srcPos = uespos + 2;
            tarPos += copyLength;
            copy[tarPos] = (byte) (0x50 ^ data[uespos + 1]);
            tarPos += 1;
        }

        if (srcPos < data.length) {
            copyLength = data.length - srcPos;
            System.arraycopy(data, srcPos, copy, tarPos, copyLength);
        }

        return copy;
    }

    public static byte[] encode(byte cmdId, String deviceId, String sn, byte[] body) {
        // System.out.println(sn);
        byte[] data = new byte[2];
        copyShort(data, 0, Integer.parseInt(sn));
        return encode(cmdId, deviceId, data, body);
    }

    public static byte[] encode(byte cmdId, String deviceId, byte[] snBytes, byte[] body) {
        byte[] common = encodeCommon(cmdId, deviceId, snBytes, body);
        return common;
    }


    private static byte[] encodeCommon(byte cmdId, String deviceId, byte[] snBytes, byte[] body) {
        byte[] noHeadTail = new byte[12 + body.length];
        ProtocalUtil util = new ProtocalUtil();
        // util.convertAddrStrToByte(addrStr)
        int postion = 0;
        byte[] addresses = util.hexStringToByte(deviceId);
        System.arraycopy(addresses, 0, noHeadTail, postion, 8);
        postion += 8;
        noHeadTail[postion] = cmdId;
        postion += 1;
        noHeadTail[postion] = (byte) (body.length + 2);
        postion += 1;

        System.arraycopy(snBytes, 0, noHeadTail, postion, 2);
        postion += 2;
        System.arraycopy(body, 0, noHeadTail, postion, body.length);
        byte[] response = new byte[4 + noHeadTail.length];
        response[0] = 0x7e;
        response[1] = 0x7e;
        response[2] = 0x7e;
        int crc = CrcUtil.validate(noHeadTail);
        // copyShort(noHeadTail, 9 + body.length, crc);
        // noHeadTail[noHeadTail.length-1] = (byte)crc;
        System.arraycopy(noHeadTail, 0, response, 3, noHeadTail.length);
        response[response.length - 1] = (byte) crc;
        return response;
    }

    /**
     * TODO.
     *
     * @param dataItemMap value command value
     * @param dataByte
     * @param dataPos
     * @param dataType2
     * @return
     */
    protected static int convertData(Map<String, String> dataItemMap, byte[] dataByte, int dataPos, DataType2 dataType2) {
        String eleName = dataType2.getElementName();
        int eleType = dataType2.getElementType();
        int eleLen = dataType2.getElementLen();

        String val = dataItemMap.get(eleName);

        switch (eleType) {
            case DATA_TYPE_STR:// 字符串转字节数组
                System.arraycopy(val.getBytes(), 0, dataByte, dataPos, eleLen);
                break;
            case 2:
                break;
            case DATA_TYPE_BCD:
                // Util.bcd2str(bcd, offset, length);
                break;
            default:
                break;
        }
        dataPos += eleLen;

        return dataPos;
    }

    /**
     * @param dtiMap
     * @param valueMap
     * @param dataItem
     * @return
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public byte[] encode(Map dtiMap, Map<String, String> valueMap, AFN dataItem) {
        List<DataElementType> dataElementList = dataItem.getDataElement();
        List<DataType2> dataList = dataItem.getData();
        // Map<String,String> valueMap = new HashMap<>();
        RefactorData refactorData = null;
        // If there is no data unit definition of the data structure
        if (dataList != null) {
            refactorData = refactorDataType(valueMap, dataList, null);
        }

        byte[] total = null;

		/*Map dtiMap  = new HashMap<>();
        if(dataItems != null && dataItems.size() >0) {

			for (int i = 0;i<dataItems.size();i++) {
				Map map = (Map) dataItems.get(i);
				String dti =  (String) map.get("id");
				Map paramMap  = (Map) map.get(DataTypeConstant.PARAMS);
				dtiMap.put(dti, paramMap);
			}

		}*/
        if (dataElementList != null && dataElementList.size() > 0) {

            RefactorData subData = null;
            byte[] tempByte = null;
            int pos = 0;

            //fix by kerry on 2017.11.10
            for (Object o : dtiMap.entrySet()) {
                Map.Entry entry = (Map.Entry) o;
                String valueIdKey = entry.getKey().toString();
                for (DataElementType dataElementType : dataElementList) {
                    String dtiCode = "" + dataElementType.getDataCatagory();

                    if (!valueIdKey.equals(dtiCode)) {
                        continue;
                    }
                    List<DataType> dataTypeList = dataElementType.getData();
                    Map paramMap = (Map) entry.getValue();
                    int num = dataElementType.getNum();
                    paramMap.put(DataTypeConstant.DataType, dtiCode);
                    paramMap.put(DataTypeConstant.NUM, String.valueOf(num));
                    for (int k = 0; k < num; k++) {

                        if (dataTypeList != null && dataTypeList.size() > 0) {
                            for (DataType dataType : dataTypeList) {
                                List<DataType2> dataType1 = dataType.getD1();
                                //DataType2 dataType2 = dataType.getD2();

                                if (dataType1 != null && dataType1.size() > 0) {
                                    subData = refactorDataType(valueMap, dataType1, paramMap);
                                }

                                byte[] contentByte = null;
                                byte[] innnerBytes = subData.getContent();
                                int len = innnerBytes.length;
                                if (tempByte != null && tempByte.length != 0) {
                                    contentByte = new byte[tempByte.length];
                                    System.arraycopy(tempByte, 0, contentByte, 0, tempByte.length);
                                    tempByte = new byte[pos + len];
                                    System.arraycopy(contentByte, 0, tempByte, 0, contentByte.length);
                                }
                                //byte[] dataBytes = refactorData.getContent();
                                //System.arraycopy(innnerBytes, 0, tempByte, 0, innnerBytes.length);
                                if (tempByte == null) {
                                    tempByte = new byte[innnerBytes.length];
                                    //tempByte = new byte[headByte.length];
                                    // System.arraycopy(src, srcPos, dest, destPos, length);
                                }

                                System.arraycopy(innnerBytes, 0, tempByte, pos, len);
                                pos += len;
                                /*
                                int pos = 0;
                                System.arraycopy(dataBytes, 0, total, pos, dataBytes.length);
                                pos += dataBytes.length;
                                System.arraycopy(innnerBytes, 0, total, pos, innnerBytes.length);
                                */
                            }
                        }
                    }
                    break;
                }

            }
            //end fix

            byte[] dataBytes = refactorData.getContent();
            if (dataBytes != null && tempByte != null) {
                total = new byte[dataBytes.length + tempByte.length];
                System.arraycopy(dataBytes, 0, total, 0, dataBytes.length);
                System.arraycopy(tempByte, 0, total, dataBytes.length, tempByte.length);
            } else if (dataBytes != null) {
                return dataBytes;
            } else if (tempByte != null) {
                return tempByte;
            }
        } else {
            total = refactorData.getContent();
        }
        return total;
    }


    class RefactorData {
        byte[] content;

        public byte[] getContent() {
            return content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public int getPos() {
            return pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        int pos;
    }

    public RefactorData refactorDataType(Map<String, String> valueMap, List<DataType2> dataList, Map<String, String> paramMap) {
        RefactorData data = new RefactorData();
        byte[] tempByte = null;
        int pos = 0;
        for (DataType2 dt2 : dataList) {
            if (dt2 != null) {
                String eleName = dt2.getElementName();
                int eleType = dt2.getElementType();
                int len = dt2.getElementLen();


                String factor = dt2.getElementFactor();
                String fieldVal = null;
                if (eleName.equals(DataTypeConstant.MP) || eleName.equals(DataTypeConstant.SN)) {
                    fieldVal = valueMap.get(eleName);
                    if (fieldVal == null) {
                        fieldVal = "0";
                    }
                } else {
                    if (paramMap != null && paramMap.size() > 0) {
                        fieldVal = paramMap.get(eleName);
                        if (fieldVal == null) {
                            fieldVal = "0";
                        }
                    } else {

                        fieldVal = dt2.getElementValue();
                    }
                }

                if (len == -1) {
                    byte[] byteStr = new ProtocalUtil().hexStringToByte(fieldVal);
                    len = byteStr.length;
                }
                byte[] headByte = new byte[len];
                byte[] contentByte = null;
                if (tempByte != null && tempByte.length != 0) {
                    contentByte = new byte[tempByte.length];
                    System.arraycopy(tempByte, 0, contentByte, 0, tempByte.length);
                    tempByte = new byte[len + pos];
                    System.arraycopy(contentByte, 0, tempByte, 0, contentByte.length);
                }

                switch (eleType) {
                    /*case DataTypeConstant.CHAR:
                        headByte[0] = (byte) Byte.valueOf(fieldVal);
						break;*/
                    case DataTypeConstant.STR:
                        System.arraycopy(fieldVal.getBytes(), 0, headByte, 0, fieldVal.length());
                        break;
                    case DataTypeConstant.HEX:
                        System.arraycopy(new ProtocalUtil().hexStringToByte(fieldVal), 0, headByte, 0, len);
                        break;
                    case DataTypeConstant.WORD:
                        byte[] wordData = new byte[len];
                        int val = 0;
                        if (factor != null && !"1".equals(factor)) {
                            val = new BigDecimal(fieldVal).multiply(new BigDecimal(factor)).intValue();
                            ProtocalUtil.convert2Byte(wordData, 0, val);
                        } else {
                            //FIXME kerryzhang,避免溢出,2017.11.07
///                            ProtocalUtil.convert2Byte(wordData, 0, Integer.parseInt(fieldVal));
                            ProtocalUtil.convert2Byte(wordData, 0, Long.parseLong(fieldVal));
                        }
                        System.arraycopy(wordData, 0, headByte, 0, len);
                        break;
                    /*case DataTypeConstant.DWORD:
                        byte [] dwordData =new byte[4];
						convert2Byte(dwordData, 0, Short.valueOf(fieldVal));
						System.arraycopy(dwordData, 0, headByte, 0, len);
						break;*/
                    case DataTypeConstant.TIME:
                        TimeTag timeTag = new TimeTag(System.currentTimeMillis());
                        byte[] andTime = timeTag.toMiddleBcd();
                        System.arraycopy(andTime, 0, headByte, 0, len);

                    default:
                        // System.arraycopy(Integer.valueOf(fieldVal), 0, headByte, pos, len);
                        break;

                }

                if (tempByte == null) {
                    tempByte = new byte[headByte.length];
                    // System.arraycopy(src, srcPos, dest, destPos, length);
                }

                System.arraycopy(headByte, 0, tempByte, pos, len);
                pos += len;
            }
        }
        data.setContent(tempByte);
        data.setPos(pos);
        return data;
    }

    public static byte[] getBodyByte(VcarecityPD pd, byte[] headByte, byte[] tempByte) {
        String startSymbol = pd.getProtocalStartSymbol();
        int startSymbolLen = pd.getProtocalStartSymbolLen();
        /// int dataLen = pd.getDataLen().getLen();

        int totalLen = startSymbolLen + headByte.length;
        if (tempByte != null) {
            totalLen += tempByte.length;
        }

        byte[] bodyByte = new byte[totalLen];
        int position = 0;
        System.arraycopy(new ProtocalUtil().hexStringToByte(startSymbol), 0, bodyByte, 0, startSymbolLen);
        System.arraycopy(HexUtil.hexToByteArray(startSymbol), 0, bodyByte, 0, startSymbolLen);
        position += startSymbolLen;
        System.arraycopy(headByte, 0, bodyByte, position, headByte.length);
        position += headByte.length;
        if (tempByte != null) {
            System.arraycopy(tempByte, 0, bodyByte, position, tempByte.length);
        }
        int endSymbolLen = pd.getProtocalEndSymbolLen();
        String endSymbol = pd.getProtocalEndSymbol();
        if (endSymbol != null && endSymbol.length() > 0) {
            System.arraycopy(endSymbol.getBytes(), 0, bodyByte, position, endSymbolLen);
            // position += endSymbolLen;
        }

        return bodyByte;
    }


    public static void copyInt(byte[] data, int offset, long v) {
        data[offset] = (byte) (v >> 24);
        data[offset + 1] = (byte) (v >> 16);
        data[offset + 2] = (byte) (v >> 8);
        data[offset + 3] = (byte) v;
    }

    public static void convert2Byte(byte[] data, int offset, long v) {
        int len = data.length;
        for (int i = 0; i < len; i++) {
            data[offset + i] = (byte) (v >> (len - i - 1) * 8);
        }
    }

    public static void copyShort(byte[] data, int offset, long v) {
        data[offset] = (byte) (v >> 8);
        data[offset + 1] = (byte) v;
    }

    public static synchronized String getsn() {
        return "0000000000";
    }

    public static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_UP;

    public static final BigDecimal M_SPEED = new BigDecimal("1.852");

    public static String unitIPToUserIP(String unitIP) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; i++) {
            sb.append(Integer.valueOf(unitIP.substring(i * 3, i * 3 + 3)));
            sb.append(".");
        }

        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }

        return sb.toString();
    }

    public static int jieToSpeed(int jie) {
        BigDecimal jiespeed = new BigDecimal(jie);
        BigDecimal speed = jiespeed.multiply(FepPackageUtil.M_SPEED);
        speed = speed.setScale(0, FepPackageUtil.ROUNDING_MODE);
        return speed.intValue();
    }

    public static int speedTOJie(int speed) {
        BigDecimal decspeed = new BigDecimal(speed);
        BigDecimal jspeed = decspeed.divide(FepPackageUtil.M_SPEED, 0, FepPackageUtil.ROUNDING_MODE);
        return jspeed.intValue();
    }
/*
    public static void commonAckUnit(byte cmdId, FepSocketSession session, FepPackage pkg) {
        String deviceId = session.getUnitInfo().getDeviceId();
        // byte[] resBody = deviceId.getBytes();
        byte[] res = FepPackageUtil.encode(cmdId, deviceId, pkg.getSerialNumberBytes(), Constants.ZERO_BYTES_DATA);
        session.sendData(res);
    }
*/


}
