package com.vcarecity.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;

/**
 * 字节转换工具类
 *
 * @author liujiajin
 */
public class ProtocalUtil {

    public static final int NUMBER_SIGN_POSITIVE = 1;
    public static final int NUMBER_SIGN_NEGATIVE = 2;

    public static final int BCD_HIGH_DIGIT = 1;
    public static final int BCD_LOW_DIGIT = 2;

    public static final int BITMOVE_DIR_RIGHT = 1;
    public static final int BITMOVE_DIR_LEFT = 2;


    public byte[] convertAddrStrToByte(String addrStr) {
        if (addrStr == null || addrStr.length() != 4) {
            return null;
        }
        byte[] addr = hexStringToByte(addrStr);
        byte temp = addr[0];
        addr[0] = addr[1];
        addr[1] = temp;
        return addr;
    }

    public byte[] converToAddrByteOnlyAddr(String addrStr) {
        if (addrStr == null) {
            return null;
        }
        StringBuilder addrStrBuilder = new StringBuilder(addrStr);
        while (addrStrBuilder.length() < 4) {
            addrStrBuilder.insert(0, "0");
        }
        addrStr = addrStrBuilder.toString();
        String temp = addrStr.substring(2, 4);
        temp += addrStr.substring(0, 2);
        byte[] addr = hexStringToByte(temp);
        return addr;
    }

    public static long convertByte2Int(byte[] b) {
        long accum = 0;
        for (int i = 0; i < b.length; i++) {
            accum = accum | ((long) b[i] & 0xff) << (8 * (b.length - (i + 1)));
        }
        return accum;
    }

    public static void convert2Byte(byte[] data, int offset, long v) {
        int len = data.length;
        for (int i = 0; i < len; i++) {
            data[offset + i] = (byte) (v >> (len - i - 1) * 8);
        }
    }

    public static String bytesToHexString(byte[] data) {
        if (data != null) {
            StringBuilder result = new StringBuilder();
            for (byte aData : data) {
                result.append(bytesToHexString(aData));
            }
            return result.toString().toUpperCase();
        }
        return "";
    }

    public static String bytesToHexString(byte input) {
        String str = input > 15 ? "" : "0";
        str += Integer.toHexString(input);
        if (str.length() > 2) {
            str = str.substring(str.length() - 2);
        }
        return str;
    }


    /**
     * @param b
     * @return
     */
    public static long getFloat(byte[] b) {
        long accum = 0;

        accum = accum | (b[7] & 0xff) << 0;
        accum = accum | ((long) b[6] & 0xff) << 8;
        accum = accum | ((long) b[5] & 0xff) << 16;
        accum = accum | ((long) b[4] & 0xff) << 24;
        accum = accum | ((long) b[3] & 0xff) << 32;
        accum = accum | ((long) b[2] & 0xff) << 40;
        accum = accum | ((long) b[1] & 0xff) << 48;
        accum = accum | ((long) b[0] & 0xff) << 56;
        return accum;
    }

    /**
     * @param b
     * @return
     */
    public static long getFloatFor4(byte[] b) {
        long accum = 0;
        accum = accum | (b[3] & 0xff) << 0;
        accum = accum | ((long) b[2] & 0xff) << 8;
        accum = accum | ((long) b[1] & 0xff) << 16;
        accum = accum | ((long) b[0] & 0xff) << 24;

        return accum;
    }


    public String hexToDecString(byte[] data) {
        if (data != null) {
            String result = "";
            for (int i = 0; i < data.length; i++) {
                String temp = "";
                if (data[i] > 9) {
                    return "";
                }
                temp += Integer.toHexString(data[i]);
                if (temp.length() > 1) {
                    temp = temp.substring(temp.length() - 1);
                }
                result += temp;
            }
            return result;
        }
        return "";
    }


    /**
     * convert to byte array to hex String.
     *
     * @param data
     * @return
     */
    public String hexToHexString(byte[] data) {
        if (data != null) {
            StringBuilder result = new StringBuilder();
            for (byte aData : data) {
                result.append(hexToHexString(aData));
            }
            return result.toString().toUpperCase();
        }
        return "";
    }

    public String hexToHexString(byte input) {
        String str = input > 15 ? "" : "0";
        str += Integer.toHexString(input);
        if (str.length() > 2) {
            str = str.substring(str.length() - 2);
        }
        return str;
    }


    public int hexToInt(byte[] data) {
        if (data == null || data.length < 1 || data.length > 4) {
            return -1;
        }
        int result = 0;
        int len = data.length;
        for (int i = 0; i < len; i++) {
            int ch = hexToInt(data[len - 1 - i]);

            result += ch << (8 * i);
        }
        if (data.length == 1 && result < 0) {
            result += 256;
        }
        return result;
    }


    public int hexToInt(byte data) {
        return (data & 0xff);
    }


    public int hexToShort(byte[] data) {
        if (data == null || data.length != 2) {
            return -1;
        }
        for (int i = 0; i < 2; i++) {
            int intVal = hexToInt(data[i]);
            data[i] = (byte) intVal;
        }

        int highValue = hexToInt(data[0]) << 8;
        int lowValue = hexToInt(data[1]);

        return highValue + lowValue;
    }


    public byte[] shortToHex(int data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(data);
            baos.close();
            dos.close();
            byte[] ret = baos.toByteArray();
            if (ret != null && ret.length == 2) {
                byte temp = ret[0];
                ret[0] = ret[1];
                ret[1] = temp;
                return ret;
            } else {
                return null;
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] intToHex(long data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt((int) data);
            baos.close();
            dos.close();
            byte[] ret = baos.toByteArray();
            if (ret != null && ret.length == 4) {
                ret = reverseByteOrder(ret);
                return ret;
            } else {
                return null;
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }


    public byte[] hexStringToByte(String srcStr) {
        
        if (srcStr == null || "".equals(srcStr)) {
            return null;
        }

        if (srcStr.length() % 2 != 0) {
            srcStr = '0' + srcStr;
        }

        int len = srcStr.length() / 2;
        byte[] data = new byte[len];
        for (int i = 0; i < len; i++) {
            String temp = srcStr.substring(i * 2, i * 2 + 2);
            int val = Integer.parseInt(temp, 16);
            data[i] = (byte) val;
        }
        return data;
    }


    public byte[] bcdStringToByte(String str) {
        if (str == null || "".equals(str) || str.length() % 2 != 0) {
            return null;
        }

        int len = str.length() / 2;
        byte[] data = new byte[len];
        for (int i = 0; i < len; i++) {
            String temp = str.substring(i * 2, i * 2 + 2);
            try {
                int val = Integer.parseInt(temp);
                data[i] = (byte) val;
            } catch (NumberFormatException e) {
                return null;
            }
        }
        return data;
    }

    public byte hexToBcd(byte hexVal, int addVal) {
        return (byte) (hexVal % 10 + ((hexVal / 10) % 10) * 16 + addVal);
    }


    public byte[] reverseByteOrder(byte[] data) {
        if (data != null && data.length != 0) {
            for (int i = 0; i < data.length / 2; i++) {
                byte temp = data[i];
                data[i] = data[data.length - i - 1];
                data[data.length - i - 1] = temp;
            }
        }
        return data;
    }

    public String reverseStringOrder(String data) {
        if (data == null || data.length() < 1) {
            return data;
        }
        String result = "";
        for (int i = 0; i < data.length(); i++) {
            String temp = data.substring(i, i + 1);
            result = temp + result;
        }
        return result;
    }

    public byte bitMove(byte data, int direction) {
        int intData = hexToInt(data);
        if (direction == BITMOVE_DIR_LEFT) {
            intData = intData << 1;
        } else {
            intData = intData >> 1;
        }
        return (byte) intData;
    }

    public byte bitMove(byte data, int direction, int num) {
        for (int i = 0; i < num; i++) {
            data = bitMove(data, direction);
        }
        return data;
    }

    public byte[] calXiTongPwd(byte[] data, byte[] pwd, int beginPos, int len) {
        if (data == null || data.length < (beginPos + len) || pwd == null || pwd.length != 2) {
            return null;
        }
        byte crc16Low = 0x00;
        byte crc16High = 0x00;

        byte pwdLow = pwd[0];
        byte pwdHigh = pwd[1];

        for (int i = beginPos; i < beginPos + len; i++) {
            crc16Low ^= data[i];
            for (int j = 0; j < 8; j++) {
                byte temp16Low = crc16Low;
                byte temp16High = crc16High;

                crc16Low = bitMove(crc16Low, BITMOVE_DIR_RIGHT);
                crc16High = bitMove(crc16High, BITMOVE_DIR_RIGHT);
                if ((temp16High & 0x01) == 0x01) {
                    crc16Low = (byte) (crc16Low | 0x80);
                }
                if ((temp16Low & 0x01) == 0x01) {
                    crc16High ^= pwdHigh;
                    crc16Low ^= pwdLow;
                }
            }
        }

        return new byte[]{crc16Low, crc16High};
    }

    public int pow2(int num) {
        int value = 1;
        for (int i = 0; i < num; i++) {
            value *= 2;
        }
        return value;
    }

    public String convertSqlCharToDate(String dbType, String time) {
        String sql = new String();
        if ("oracle".equalsIgnoreCase(dbType)) {
            sql = " to_date('" + time + "','YYYY-MM-DD HH24:MI:SS') ";
        } else if ("sybase".equalsIgnoreCase(dbType)) {
            sql = " '" + time + "' ";
        }
        return sql;
    }

    public String convertSqlDateToChar(String dbType, String time) {
        String sql = new String();
        if ("oracle".equalsIgnoreCase(dbType)) {
            sql = " to_char(" + time + ",'YYYY-MM-DD HH24:MI:SS')";
        } else if ("sybase".equalsIgnoreCase(dbType)) {
            sql = time;
        }
        return sql;
    }

    public int get1Num(byte b) {
        int num = 0;
        for (int i = 0; i < 8; i++) {
            if ((b & pow2(i)) != 0) {
                num++;
            }
        }
        return num;
    }

    public static byte[] doubleToByte(double d) {
        byte[] b = new byte[8];
        long l = Double.doubleToLongBits(d);
        for (int i = 0; i < b.length; i++) {
            b[i] = new Long(l).byteValue();
            l = l >> 8;

        }
        return b;
    }

    public static String formatData(int data, int digit) {
        String integer = "#0";
        switch (digit) {
            case 0: {
                DecimalFormat df = new DecimalFormat(integer);
                return df.format(data);
            }
            case 1: {
                DecimalFormat df = new DecimalFormat(integer + ".0");
                float value = (float) data / 10;
                return df.format(value);
            }
            case 2: {
                DecimalFormat df = new DecimalFormat(integer + ".00");
                float value = (float) data / 100;
                return df.format(value);
            }
            case 3: {
                DecimalFormat df = new DecimalFormat(integer + ".000");
                float value = (float) data / 1000;
                return df.format(value);
            }
            case 4: {
                DecimalFormat df = new DecimalFormat(integer + ".0000");
                float value = (float) data / 10000;
                return df.format(value);
            }
            case 5: {
                DecimalFormat df = new DecimalFormat(integer + ".00000");
                float value = (float) data / 100000;
                return df.format(value);
            }
            case 6: {
                DecimalFormat df = new DecimalFormat(integer + ".000000");
                float value = (float) data / 1000000;
                return df.format(value);
            }
            default: {
                DecimalFormat df = new DecimalFormat(integer + ".00");
                float value = (float) data / 100;
                return df.format(value);
            }
        }
    }

   /* public static void main(String[] args) {
        ProtocalUtil prtl = new ProtocalUtil();
//		String b=prtl.hexToHexString(new byte[]{0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x0d});
        int i = 1544;
        byte[] ss = prtl.bcdStringToByte(String.valueOf(i));
        System.out.println(prtl.hexToHexString(ss));

    }
*/
}
