package com.vcarecity.xml.util;

import java.text.NumberFormat;
import java.util.Calendar;

public class TimeTag implements Cloneable {
    public static final int TIMETYPE_A = 5;

    public static final int TIMETYPE_B = 7;


    public static final int TIMEUNIT_SECOND = 0;

    public static final int TIMEUNIT_MINUTE = 1;

    public static final int TIMEUNIT_HOUR = 2;

    public static final int TIMEUNIT_DAY = 3;

    public static final int TIMEUNIT_MONTH = 4;

    public static final int TIMEUNIT_YEAR = 5;

    public static final int TIMEUNIT_WEEK = 6;

    public static final int TIMEUNIT_MILLISECOND = 7;

    public int year = 0, month = 0, day = 0, hour = 0, minute = 0, second = 0,
            week = 0;

    public long millisecond = 0;

    private Calendar calendar = Calendar.getInstance();

    private ProtocalUtil protocol = new ProtocalUtil();

    public TimeTag() {
    }

    public TimeTag(long millis) {
        setTime(millis);
    }

    public TimeTag(int year, int month, int day, int hour, int minute, int second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        setCalendar();
    }

    public TimeTag(int year, int month, int day, int hour, int minute,
                   int second, long ms) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = ms;
        setCalendar();
    }

    public TimeTag(int year, int month, int day, int hour, int minute,
                   int second, int week) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.week = week;
        setCalendar();
    }

    public TimeTag(int year, int month, int day, int hour, int minute,
                   int second, int week, long ms) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.week = week;
        this.millisecond = ms;
        setCalendar();
    }

    public boolean isValid() {
        if (year < 2000 || month > 12 || month < 1 || day < 1 || day > 31
                || hour < 0 || hour > 25 || minute < 0 || minute > 59 || second < 0
                || second > 59 || millisecond > 1000) {
            return false;
        }
        return true;
    }

    public void setTime(int year, int month, int day, int hour, int minute) {
        if (year < 2000) {
            this.year = year + 2000;
        } else {
            this.year = year;
        }
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = 0;
        setCalendar();
    }

    public void setTime(TimeTag timeTag) {
        this.year = timeTag.year;
        this.month = timeTag.month;
        this.day = timeTag.day;
        this.hour = timeTag.hour;
        this.minute = timeTag.minute;
        setCalendar();
    }

    public void setTime(Calendar calendar) {
        year = calendar.get(Calendar.YEAR);
        month = calendar.get(Calendar.MONTH) + 1;
        day = calendar.get(Calendar.DATE);
        hour = calendar.get(Calendar.HOUR_OF_DAY);
        minute = calendar.get(Calendar.MINUTE);
        second = calendar.get(Calendar.SECOND);
        setCalendar();
    }

    public void setTime(long millis) {
        calendar.setTimeInMillis(millis);
        calendar.set(Calendar.MILLISECOND, 0);
        year = calendar.get(Calendar.YEAR);
        month = calendar.get(Calendar.MONTH) + 1;
        day = calendar.get(Calendar.DATE);
        hour = calendar.get(Calendar.HOUR_OF_DAY);
        minute = calendar.get(Calendar.MINUTE);
        second = calendar.get(Calendar.SECOND);
    }

    public void setTimeWithMillSec(long millis) {
        calendar.setTimeInMillis(millis);
        year = calendar.get(Calendar.YEAR);
        month = calendar.get(Calendar.MONTH) + 1;
        day = calendar.get(Calendar.DATE);
        hour = calendar.get(Calendar.HOUR_OF_DAY);
        minute = calendar.get(Calendar.MINUTE);
        second = calendar.get(Calendar.SECOND);
        millisecond = calendar.get(Calendar.MILLISECOND);
    }

    public void setCalendar() {
        calendar.set(Calendar.YEAR, year);
        calendar.set(Calendar.MONTH, month - 1);
        calendar.set(Calendar.DATE, day);
        calendar.set(Calendar.HOUR_OF_DAY, hour);
        calendar.set(Calendar.MINUTE, minute);
        calendar.set(Calendar.SECOND, second);
        calendar.set(Calendar.MILLISECOND, 0);
    }

    public void setTimeAddMin(Calendar calendar) {
        year = calendar.get(Calendar.YEAR);
        month = calendar.get(Calendar.MONTH) + 1;
        day = calendar.get(Calendar.DATE);
        hour = calendar.get(Calendar.HOUR_OF_DAY);
        minute = calendar.get(Calendar.MINUTE) + 1;
        second = calendar.get(Calendar.SECOND);
        setCalendar();
    }

    public long getMillis() {
        return calendar.getTimeInMillis();
    }

    public byte[] toBcd() {
        byte[] bcdTime = new byte[]{protocol.hexToBcd((byte) (year - 2000), 0),
                protocol.hexToBcd((byte) month, 0), protocol.hexToBcd((byte) day, 0),
                protocol.hexToBcd((byte) hour, 0), protocol.hexToBcd((byte) minute, 0)};
        return bcdTime;
    }

    public byte[] toIEEETime() {
        return protocol.intToHex(getMillis() / 1000);
    }

    public byte[] toMiddleBcd() {
        byte[] bcdTime = new byte[]{protocol.hexToBcd((byte) (year - 2000), 0),
                protocol.hexToBcd((byte) month, 0), protocol.hexToBcd((byte) day, 0),
                protocol.hexToBcd((byte) hour, 0), protocol.hexToBcd((byte) minute, 0),
                protocol.hexToBcd((byte) second, 0)};
        return bcdTime;
    }

    public byte[] toBcdWithMillisecond() {
        byte[] bcdTime = new byte[]{protocol.hexToBcd((byte) (year - 2000), 0),
                protocol.hexToBcd((byte) month, 0), protocol.hexToBcd((byte) day, 0),
                protocol.hexToBcd((byte) hour, 0), protocol.hexToBcd((byte) minute, 0),
                protocol.hexToBcd((byte) second, 0),
                protocol.hexToBcd((byte) millisecond, 0)};
        return bcdTime;
    }

    public byte[] toBigBcd() {
        byte[] bcdTime = new byte[]{protocol.hexToBcd((byte) (year - 2000), 0),
                protocol.hexToBcd((byte) month, 0), protocol.hexToBcd((byte) day, 0),
                protocol.hexToBcd((byte) hour, 0), protocol.hexToBcd((byte) minute, 0),
                protocol.hexToBcd((byte) minute, 0), protocol.hexToBcd((byte) week, 0)};
        return bcdTime;
    }


    public byte[] toTimeA() {
        byte[] time = new byte[TimeTag.TIMETYPE_A];
        time[0] = (byte) (this.minute & 0x3F);
        time[1] = (byte) (this.hour & 0x1F);
        time[2] = (byte) (this.day & 0x1F);
        time[3] = (byte) (this.month & 0x0F);
        time[4] = (byte) (this.year & 0x0F);
        return time;
    }

    public byte[] toTimeB() {
        byte[] time = new byte[TimeTag.TIMETYPE_B];
        byte[] mills = protocol.shortToHex((int) millisecond);
        time[0] = (byte) (mills[0] & 0xFF);
        time[1] = (byte) (mills[1] & 0x03 + second & 0xFC);
        time[2] = (byte) (this.minute & 0x3F);
        time[3] = (byte) (this.hour & 0x1F);
        time[4] = (byte) (this.day & 0x1F);
        time[5] = (byte) (this.month & 0x0F);
        time[6] = (byte) (this.year & 0x0F);
        return time;
    }

    public byte[] getByteTime(byte addValue) {
        byte[] byteTime = new byte[]{(byte) (year - 2000 + addValue),
                (byte) (month + addValue), (byte) (day + addValue),
                (byte) (hour + addValue), (byte) (minute + addValue)};
        return byteTime;
    }

    public byte[] getRervseBinTime() {
        byte[] binTime = new byte[]{(byte) minute, (byte) hour, (byte) day, (byte) month, (byte) (year - 2000)};
        return binTime;
    }

    public int getMaxDay() {
        return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    }

    public boolean equalTime(byte[] otherTime, byte minusValue) {
        if (otherTime == null || otherTime.length != 5) {
            return false;
        }
        if (year != otherTime[0] + 2000 - minusValue) {
            return false;
        }
        if (month != otherTime[1] - minusValue) {
            return false;
        }
        if (day != otherTime[2] - minusValue) {
            return false;
        }
        if (hour != otherTime[3] - minusValue) {
            return false;
        }
        return minute == otherTime[4] - minusValue;
    }

    public int compare(TimeTag other) {
        if (year < other.year) {
            return -1;
        } else if (year > other.year) {
            return 1;
        } else if (year == other.year) {
            if (month < other.month) {
                return -1;
            } else if (month > other.month) {
                return 1;
            } else if (month == other.month) {
                if (day < other.day) {
                    return -1;
                } else if (day > other.day) {
                    return 1;
                } else if (day == other.day) {
                    if (hour < other.hour) {
                        return -1;
                    } else if (hour > other.hour) {
                        return 1;
                    } else if (hour == other.hour) {
                        if (minute < other.minute) {
                            return -1;
                        } else if (minute > other.minute) {
                            return 1;
                        } else if (minute == other.minute) {
                            return 0;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public static int compare(TimeTag timeTag1, TimeTag timeTag2) {
        if (timeTag1.year < timeTag2.year) {
            return -1;
        } else if (timeTag1.year > timeTag2.year) {
            return 1;
        } else if (timeTag1.year == timeTag2.year) {
            if (timeTag1.month < timeTag2.month) {
                return -1;
            } else if (timeTag1.month > timeTag2.month) {
                return 1;
            } else if (timeTag1.month == timeTag2.month) {
                if (timeTag1.day < timeTag2.day) {
                    return -1;
                } else if (timeTag1.day > timeTag2.day) {
                    return 1;
                } else if (timeTag1.day == timeTag2.day) {
                    if (timeTag1.hour < timeTag2.hour) {
                        return -1;
                    } else if (timeTag1.hour > timeTag2.hour) {
                        return 1;
                    } else if (timeTag1.hour == timeTag2.hour) {
                        if (timeTag1.minute < timeTag2.minute) {
                            return -1;
                        } else if (timeTag1.minute > timeTag2.minute) {
                            return 1;
                        } else if (timeTag1.minute == timeTag2.minute) {
                            return 0;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public static int compareTime(TimeTag timeTag, TimeTag contrastTime, int field) {
        int ret = 0;
        switch (field) {
            case TimeTag.TIMEUNIT_YEAR: {
                ret = timeTag.year - contrastTime.year;
                break;
            }
            case TimeTag.TIMEUNIT_MONTH: {
                int invalYear = timeTag.year - contrastTime.year;
                ret = invalYear * 12;
                ret += timeTag.month - contrastTime.month;
                break;
            }
            case TimeTag.TIMEUNIT_DAY: {
                ret = (int) ((timeTag.getMillis() - contrastTime.getMillis()) / (24 * 60 * 60 * 1000));
                break;
            }
            case TimeTag.TIMEUNIT_HOUR: {
                ret = (int) ((timeTag.getMillis() - contrastTime.getMillis()) / (60 * 60 * 1000));
                break;
            }
            case TimeTag.TIMEUNIT_MINUTE: {
                ret = (int) ((timeTag.getMillis() - contrastTime.getMillis()) / (60 * 1000));
                break;
            }
            default:
                break;
        }
        return ret;
    }

    public void add(int field, int amount) {
        switch (field) {
            case TIMEUNIT_YEAR: {
                calendar.add(Calendar.YEAR, amount);
                break;
            }
            case TIMEUNIT_MONTH: {
                calendar.add(Calendar.MONTH, amount);
                break;
            }
            case TIMEUNIT_DAY: {
                calendar.add(Calendar.DATE, amount);
                break;
            }
            case TIMEUNIT_HOUR: {
                calendar.add(Calendar.HOUR_OF_DAY, amount);
                break;
            }
            case TIMEUNIT_MINUTE: {
                calendar.add(Calendar.MINUTE, amount);
                break;
            }
            default:
                break;
        }
        setTime(calendar.getTimeInMillis());
    }

    public static String getFieldDesc(int field) {
        switch (field) {
            case TIMEUNIT_MILLISECOND: {
                return "����";
            }
            case TIMEUNIT_SECOND: {
                return "��";
            }
            case TIMEUNIT_MINUTE: {
                return "����";
            }
            case TIMEUNIT_HOUR: {
                return "Сʱ";
            }
            case TIMEUNIT_DAY: {
                return "��";
            }
            case TIMEUNIT_MONTH: {
                return "��";
            }
            case TIMEUNIT_YEAR: {
                return "��";
            }
            default:
                break;
        }
        return "";
    }

    public int getWeek() {
        return calendar.get(Calendar.WEEK_OF_YEAR);
    }

    public long getMillisTime() {
        return calendar.getTimeInMillis();
    }

    public Calendar getTime() {
        return calendar;
    }

    public void formatByGatherUnit(int gatherUnit) {
        switch (gatherUnit) {
            case TIMEUNIT_SECOND: {
                break;
            }
            case TIMEUNIT_MINUTE: {
                second = 0;
                break;
            }
            case TIMEUNIT_HOUR: {
                minute = 0;
                second = 0;
                break;
            }
            case TIMEUNIT_DAY: {
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            case TIMEUNIT_MONTH: {
                day = 1;
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            case TIMEUNIT_YEAR: {
                month = 1;
                day = 0;
                hour = 0;
                minute = 0;
                second = 0;
                break;
            }
            default:
                break;
        }

        this.setCalendar();
    }

    public int get(int field) {
        switch (field) {
            case TIMEUNIT_SECOND: {
                return second;
            }
            case TIMEUNIT_MINUTE: {
                return minute;
            }
            case TIMEUNIT_HOUR: {
                return hour;
            }
            case TIMEUNIT_DAY: {
                return day;
            }
            case TIMEUNIT_MONTH: {
                return month;
            }
            case TIMEUNIT_YEAR: {
                return year;
            }
            default:
                break;
        }
        return -1;
    }

    private byte[] adjustTimeA(byte[] timeA) {
        if ((timeA == null) || timeA.length != TimeTag.TIMETYPE_A) {
            return null;
        }
        byte[] time = new byte[TimeTag.TIMETYPE_A];
        time[0] = (byte) (timeA[0] & 0x3F);
        time[1] = (byte) (timeA[1] & 0x1F);
        time[2] = (byte) (timeA[2] & 0x1F);
        time[3] = (byte) (timeA[3] & 0x0F);
        time[4] = (byte) (timeA[4] & 0x0F);
        return time;
    }

    private byte[] adjustTimeB(byte[] timeB) {
        if ((timeB == null) || timeB.length != TimeTag.TIMETYPE_B) {
            return null;
        }
        byte[] time = new byte[TimeTag.TIMETYPE_B];
        time[0] = timeB[0];
        time[1] = timeB[1];
        time[2] = (byte) (timeB[2] & 0x3F);
        time[3] = (byte) (timeB[3] & 0x1F);
        time[4] = (byte) (timeB[4] & 0x1F);
        time[5] = (byte) (timeB[5] & 0x0F);
        time[6] = (byte) (timeB[6] & 0x0F);
        return time;
    }

    public int compare(byte[] time, int timeType) {
        switch (timeType) {
            case TimeTag.TIMETYPE_A: {
                byte[] timeA = toTimeA();
                byte[] adjtimeA = adjustTimeA(time);
                for (int i = timeType - 1; i >= 0; i--) {
                    if (timeA[i] != adjtimeA[i]) {
                        return timeA[i] - adjtimeA[i];
                    }
                }
                break;
            }
            case TimeTag.TIMETYPE_B: {
                byte[] timeB = this.toTimeB();
                byte[] adjtimeB = adjustTimeB(time);
                for (int i = timeType - 1; i >= 0; i--) {
                    if (timeB[i] != adjtimeB[i]) {
                        return timeB[i] - adjtimeB[i];
                    }
                }
                break;
            }
            default:
                break;
        }
        return 0;
    }

    public static int compareTime(TimeTag timeTag1, TimeTag timeTag2, int field, int frzType) {
        TimeTag newTimeTag2 = new TimeTag(timeTag2.getMillisTime());
        if (frzType == 2) { // �ն������,��д������Ϊ�˼��ݹ������غ͹�縺��2004��Dti
            newTimeTag2.hour = 0;
            newTimeTag2.minute = 0;
            newTimeTag2.second = 0;
            newTimeTag2.setCalendar();
            //if (newTimeTag2.compare(timeTag2)<0)
            newTimeTag2.add(TimeTag.TIMEUNIT_DAY, 1);
        } else if (frzType == 4) { // �¶������
            newTimeTag2.day = 1;
            newTimeTag2.hour = 0;
            newTimeTag2.minute = 0;
            newTimeTag2.second = 0;
            newTimeTag2.setCalendar();
            //if (newTimeTag2.compare(timeTag2)<0)
            newTimeTag2.add(TimeTag.TIMEUNIT_MONTH, 1);
        }

        int ret = 0;
        switch (field) {
            case TimeTag.TIMEUNIT_YEAR: {
                ret = timeTag1.year - newTimeTag2.year;
                break;
            }
            case TimeTag.TIMEUNIT_MONTH: {
                while (timeTag1.year > newTimeTag2.year) {
                    newTimeTag2.add(TimeTag.TIMEUNIT_YEAR, 1);
                    ret += 12;
                }
                ret -= newTimeTag2.month;
                ret += timeTag1.month;
                break;
            }
            case TimeTag.TIMEUNIT_DAY: {
                ret = (int) ((timeTag1.getMillisTime() - newTimeTag2.getMillisTime()) / (24 * 60 * 60 * 1000));
                break;
            }
            case TimeTag.TIMEUNIT_HOUR: {
                ret = (int) ((timeTag1.getMillisTime() - newTimeTag2.getMillisTime()) / (60 * 60 * 1000));
                break;
            }
            case TimeTag.TIMEUNIT_MINUTE: {
                ret = (int) ((timeTag1.getMillisTime() - newTimeTag2.getMillisTime()) / (60 * 1000));
                break;
            }
            default:
                break;
        }
        return ret;
    }

    public String toDbString() {
        int dbYear = year;
        if (year < 1000) {
            dbYear += 2000;
        }
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(2);
        String time = dbYear + "-" + f.format(month) + "-" + f.format(day) + " "
                + f.format(hour) + ":" + f.format(minute) + ":" + f.format(second);
        return time;
    }

    public String toDbStringWithMillisecond() {
        int dbYear = year;
        if (year < 1000) {
            dbYear += 2000;
        }
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(2);
        NumberFormat fm = NumberFormat.getInstance();
        fm.setMinimumIntegerDigits(3);
        String time = dbYear + "-" + f.format(month) + "-" + f.format(day) + " "
                + f.format(hour) + ":" + f.format(minute) + ":" + f.format(second)
                + ":" + fm.format(millisecond);
        return time;
    }

    public String toDbStringWithWeek() {
        int dbYear = year;
        if (year < 1000) {
            dbYear += 2000;
        }
        NumberFormat fw = NumberFormat.getInstance();
        fw.setMinimumIntegerDigits(1);
        NumberFormat f = NumberFormat.getInstance();
        f.setMinimumIntegerDigits(2);
        String time = dbYear + "-" + f.format(month) + "-" + f.format(day) + " "
                + f.format(hour) + ":" + f.format(minute) + ":" + f.format(second)
                + " " + fw.format(week);
        return time;
    }

    @Override
    public String toString() {
        return toDbString();
    }

    @Override
    public Object clone() {
        TimeTag object = null;
        try {
            object = (TimeTag) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        ((TimeTag) object).calendar = (Calendar) calendar.clone();
        return object;
    }

    public static boolean isDateFormat(String dateString) {
        String[] dates = dateString.split("-| |:");
        return (dates != null) && ((dates.length == 6) || (dates.length == 7));
    }

    public static TimeTag valueOf(String timeStr) {
        if (isDateFormat(timeStr)) {
            String[] date = timeStr.split(" ");
            String[] ymd = date[0].split("-");
            String[] hms = date[1].split(":");
            int year = Integer.parseInt(ymd[0]);
            int month = Integer.parseInt(ymd[1]);
            int day = Integer.parseInt(ymd[2]);
            int hour = Integer.parseInt(hms[0]);
            int minute = Integer.parseInt(hms[1]);
            int second = Integer.parseInt(hms[2]);
            return new TimeTag(year >= 2000 ? year : year + 2000, month, day, hour, minute, second);
        }
        return null;
    }


    public static int getYearByMD(int iMon, int iDay) {
        TimeTag current = new TimeTag(System.currentTimeMillis());
        TimeTag temp = new TimeTag(current.year, iMon, iDay, 0, 0, 0);
        return current.getMillis() > temp.getMillis() ? current.year : current.year - 1;
    }

    public static void main(String[] args) {
        int iMon = 1;
        int iDay = 2;
        System.out.println(new TimeTag(TimeTag.getYearByMD(iMon, iDay), iMon, iDay, 0, 0, 0).toString());
    }
}
