package com.vcarecity.xml.xml;


import com.vcarecity.xml.xml.entity.AFN;
import com.vcarecity.xml.xml.entity.DItem;
import com.vcarecity.xml.xml.entity.DataElementType;
import com.vcarecity.xml.xml.entity.VcarecityPD;

import java.util.List;
import java.util.Map;

/**
 * @author Kerry on 18/09/10
 */

public class ProtocolHelper {
    /**
     * 协议文件
     */
    private VcarecityPD vcareType;
    /**
     * 消息头部的信息
     */
    private Map<Integer, DItem> ditMap = null;
    /**
     * 下发命令集合
     */
    private Map<Integer, List<AFN>> downAFNs = null;

    /**
     * 上行命令集合
     */
    private Map<Integer, AFN> upAfns = null;

    private Map<Integer, Map<Integer, DataElementType>> dataElementMap = null;


    public int getFrameIndex(int frameSeq) {
        int seq = 0;
        for (Map.Entry<Integer, DItem> entry : ditMap.entrySet()) {
            if (entry.getKey() < frameSeq) {
                seq += entry.getValue().getLen();
            }
        }
        return seq;
    }


    public ProtocolHelper() {
    }

    public ProtocolHelper(VcarecityPD vcareType, Map<Integer, DItem> ditMap, Map<Integer, List<AFN>> downAFNs, Map<Integer, AFN> upAfns, Map<Integer, Map<Integer, DataElementType>> dataElementMap) {
        this.vcareType = vcareType;
        this.ditMap = ditMap;
        this.downAFNs = downAFNs;
        this.upAfns = upAfns;
        this.dataElementMap = dataElementMap;
    }

    public VcarecityPD getVcareType() {
        return vcareType;
    }

    public void setVcareType(VcarecityPD vcareType) {
        this.vcareType = vcareType;
    }

    public Map<Integer, DItem> getDitMap() {
        return ditMap;
    }

    public void setDitMap(Map<Integer, DItem> ditMap) {
        this.ditMap = ditMap;
    }

    public Map<Integer, List<AFN>> getDownAFNs() {
        return downAFNs;
    }

    public void setDownAFNs(Map<Integer, List<AFN>> downAFNs) {
        this.downAFNs = downAFNs;
    }

    public Map<Integer, AFN> getUpAfns() {
        return upAfns;
    }

    public void setUpAfns(Map<Integer, AFN> upAfns) {
        this.upAfns = upAfns;
    }

    public Map<Integer, Map<Integer, DataElementType>> getDataElementMap() {
        return dataElementMap;
    }

    public void setDataElementMap(Map<Integer, Map<Integer, DataElementType>> dataElementMap) {
        this.dataElementMap = dataElementMap;
    }

}
