/*
 * Decompiled with CFR 0.152.
 */
package com.vcarecity.utilkafka;

import com.vcarecity.utilkafka.BaseKafkaProducerListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerUtil
implements BaseKafkaProducerListener {
    private Producer<String, String> producer;
    private String producerConfig;

    public static KafkaProducerUtil createKafkaProducer(String producerConfig) throws IOException {
        return KafkaProducerUtil.createKafkaProducer(producerConfig, true);
    }

    public static KafkaProducerUtil createKafkaProducer(String producerConfig, boolean isStart) throws IOException {
        KafkaProducerUtil producer = new KafkaProducerUtil(producerConfig);
        if (isStart) {
            producer.startKafka();
        }
        return producer;
    }

    private KafkaProducerUtil(String producerConfig) {
        this.producerConfig = producerConfig;
    }

    @Override
    public void startKafka() throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(this.producerConfig));
        this.producer = new KafkaProducer(props);
    }

    @Override
    public void stopKafka() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    @Override
    public void send(String topic, String value) {
        this.producer.send(new ProducerRecord(topic, (Object)value));
    }

    @Override
    public void send(String topic, String key, String value) {
        this.producer.send(new ProducerRecord(topic, (Object)key, (Object)value));
    }

    @Override
    public void send(String topic, int partition, String key, String value) {
        this.producer.send(new ProducerRecord(topic, Integer.valueOf(partition), (Object)key, (Object)value));
    }

    @Override
    public void send(String topic, int partition, long timestamp, String key, String value) {
        this.producer.send(new ProducerRecord(topic, Integer.valueOf(partition), Long.valueOf(timestamp), (Object)key, (Object)value));
    }
}

