/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.console;

import de.schlichtherle.key.PromptingKeyProvider;
import java.io.Console;
import java.util.Arrays;
import java.util.ResourceBundle;

public class PromptingKeyProviderUI
implements de.schlichtherle.key.PromptingKeyProviderUI {
    private static final String CLASS_NAME = "de.schlichtherle.key.passwd.console.PromptingKeyProviderUI";
    protected static final ResourceBundle resources = ResourceBundle.getBundle("de.schlichtherle.key.passwd.console.PromptingKeyProviderUI");
    protected static final Console con = System.console();
    private static final PromptingLock lock = new PromptingLock();
    private static final int MIN_PASSWD_LEN = 6;
    private static String lastResourceID = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void promptCreateKey(PromptingKeyProvider provider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            char[] newPasswd1;
            String resourceID = provider.getResourceID();
            if (!resourceID.equals(lastResourceID)) {
                this.printf(resources.getString("createKey.banner"), provider.getResourceID());
            }
            lastResourceID = resourceID;
            while (true) {
                if ((newPasswd1 = this.readPassword(resources.getString("createKey.newPasswd1"))) == null || newPasswd1.length <= 0) {
                    return;
                }
                char[] newPasswd2 = this.readPassword(resources.getString("createKey.newPasswd2"));
                if (newPasswd2 == null) {
                    return;
                }
                if (!Arrays.equals(newPasswd1, newPasswd2)) {
                    this.printf(resources.getString("createKey.passwd.noMatch"));
                    continue;
                }
                if (newPasswd1.length >= 6) break;
                this.printf(resources.getString("createKey.passwd.tooShort"));
            }
            provider.setKey(newPasswd1);
            this.promptExtraData(provider);
        }
    }

    protected void promptExtraData(PromptingKeyProvider provider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean promptUnknownOpenKey(PromptingKeyProvider provider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            return this.promptOpenKey(provider, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean promptInvalidOpenKey(PromptingKeyProvider provider) {
        PromptingLock promptingLock = lock;
        synchronized (promptingLock) {
            return this.promptOpenKey(provider, true);
        }
    }

    private boolean promptOpenKey(PromptingKeyProvider provider, boolean invalid) {
        String changeKey;
        String resourceID;
        if (invalid) {
            this.printf(resources.getString("openKey.invalid"));
        }
        if (!(resourceID = provider.getResourceID()).equals(lastResourceID)) {
            this.printf(resources.getString("openKey.banner"), provider.getResourceID());
        }
        lastResourceID = resourceID;
        char[] passwd = this.readPassword(resources.getString("openKey.passwd"));
        if (passwd == null || passwd.length <= 0) {
            provider.setKey(null);
            return false;
        }
        provider.setKey(passwd);
        do {
            if ((changeKey = this.readLine(resources.getString("openKey.change"))) == null) {
                return false;
            }
            if ((changeKey = changeKey.toLowerCase()).length() > 0 && !changeKey.equals(resources.getString("no"))) continue;
            return false;
        } while (!changeKey.equals(resources.getString("yes")));
        return true;
    }

    protected final Console printf(String format) {
        return con.printf(format, null);
    }

    protected final Console printf(String format, Object arg) {
        return con.printf(format, arg);
    }

    protected final String readLine(String format) {
        return con.readLine(format, null);
    }

    protected final String readLine(String format, Object arg) {
        return con.readLine(format, arg);
    }

    protected final char[] readPassword(String format) {
        return con.readPassword(format, null);
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }
}

