/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.JGitverModelProcessorWorkingConfiguration;
import fr.brouillard.oss.jgitver.JGitverUtils;
import java.io.IOException;
import java.util.Objects;
import javax.xml.bind.JAXBException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="attach-modified-poms", defaultPhase=LifecyclePhase.VERIFY, instantiationStrategy=InstantiationStrategy.SINGLETON, threadSafe=true)
public class JGitverAttachModifiedPomsMojo
extends AbstractMojo {
    public static final String GOAL_ATTACH_MODIFIED_POMS = "attach-modified-poms";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String className = JGitverModelProcessorWorkingConfiguration.class.getName();
        if (Objects.isNull(this.mavenSession.getUserProperties().get(className))) {
            this.getLog().warn((CharSequence)"attach-modified-pomsshouldn't be executed alone. The Mojo is a part of the plugin and executed automatically.");
            return;
        }
        String content = this.mavenSession.getUserProperties().getProperty(className);
        if ("-".equalsIgnoreCase(content)) {
            return;
        }
        try {
            JGitverModelProcessorWorkingConfiguration jGitverModelProcessorWorkingConfiguration = JGitverModelProcessorWorkingConfiguration.serializeFrom(content);
            JGitverUtils.attachModifiedPomFilesToTheProject(this.mavenSession.getAllProjects(), jGitverModelProcessorWorkingConfiguration.getNewProjectVersions(), this.mavenSession, (Logger)new ConsoleLogger());
            this.mavenSession.getUserProperties().setProperty(className, "-");
        }
        catch (IOException | JAXBException | XmlPullParserException ex) {
            throw new MojoExecutionException("Unable to execute goal: attach-modified-poms", (Exception)ex);
        }
    }
}

