/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.cfg;

import fr.brouillard.oss.jgitver.cfg.Configuration;
import fr.brouillard.oss.jgitver.cfg.schema.ConfigurationSchema;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.maven.MavenExecutionException;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final String NAMESPACE = "http://jgitver.github.io/maven/configuration/1.0.0-beta";

    public static Configuration loadFromRoot(File rootDirectory, Logger logger) throws MavenExecutionException {
        File extensionMavenCoreDirectory = new File(rootDirectory, ".mvn");
        File configurationXml = new File(extensionMavenCoreDirectory, "jgitver.config.xml");
        if (!configurationXml.canRead()) {
            logger.debug("no configuration file found under " + configurationXml + ", looking under backwards-compatible file name");
            configurationXml = new File(extensionMavenCoreDirectory, "jgtiver.config.xml");
            if (!configurationXml.canRead()) {
                logger.debug("no configuration file found under " + configurationXml + ", using defaults");
                return new Configuration();
            }
        }
        try {
            logger.info("using jgitver configuration file: " + configurationXml);
            String configurationContent = Files.readAllLines(configurationXml.toPath()).stream().collect(Collectors.joining("\n"));
            Configuration c = ConfigurationLoader.loadConfiguration(configurationContent);
            return c;
        }
        catch (IOException | JAXBException | SAXException ex) {
            throw new MavenExecutionException("cannot read configuration file " + configurationXml, ex);
        }
    }

    private static Configuration loadConfiguration(String configurationContent) throws JAXBException, SAXException, IOException {
        if (configurationContent.contains(NAMESPACE)) {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConfigurationSchema.class});
            StreamSource contentStreamSource = new StreamSource(new StringReader(configurationContent));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ConfigurationLoader.class.getResource("/schemas/jgitver-configuration-v1_0_0-beta.xsd"));
            Validator validator = schema.newValidator();
            validator.validate(contentStreamSource);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            ConfigurationSchema cs = (ConfigurationSchema)unmarshaller.unmarshal((Reader)new StringReader(configurationContent));
            return cs.asConfiguration();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (Configuration)unmarshaller.unmarshal((Reader)new StringReader(configurationContent));
    }
}

